<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output omit-xml-declaration="yes" method="html" encoding="UTF-8" standalone="no" />

	<xsl:param name="profileId" />
	<xsl:param name="ifaceId" />
	<xsl:param name="protocol" />
	<xsl:param name="baseUrl" />
	<xsl:param name="compliance" />
	<xsl:param name="overrideCompliance" />
	<xsl:param name="typology" />
	<xsl:param name="prefix" />
	<xsl:param name="removable" />

	<xsl:template match="/">
		<div class="row" style="margin-bottom:20px;">
			<div class="col-xs-12 col-md-offset-2 col-md-8" style="border: 1px solid #dddddd; border-radius: 4px; padding: 20px">
				<xsl:apply-templates select="//CONFIGURATION" />
			</div>
		</div>
	</xsl:template>

	<xsl:template match="CONFIGURATION">

		<xsl:variable name="country" select="normalize-space(./COUNTRY)" />

		<form class="form-horizontal">
			<wf-form-row-static name="Datasource name" value="{./OFFICIAL_NAME}" />
			<xsl:choose>
				<xsl:when test="$typology = ./DATASOURCE_TYPE">
					<wf-form-row-static name="Typology" value="{$typology}" />
				</xsl:when>
				<xsl:otherwise>
					<wf-form-row-static name="Typology" value="{./DATASOURCE_TYPE} (datasource), {$typology} (API)" style="color: #dd9900" />
				</xsl:otherwise>
			</xsl:choose>
			<wf-form-row-static name="Institution" value="{./REPOSITORY_INSTITUTION}" url="{./REPOSITORY_WEBPAGE}" />
			<wf-form-row-static name="Contact email" value="{./ADMIN_INFO}" url="{./ADMIN_INFO}" />
			<xsl:choose>
				<xsl:when test="string-length($country) = 2">
					<wf-form-row-static name="Country" value="{$country}" img="../resources/img/flags/{$country}.gif" />
				</xsl:when>
				<xsl:otherwise>
					<wf-form-row-static name="Country" value="-" />
				</xsl:otherwise>
			</xsl:choose>
			<wf-form-row-static name="Software typology" value="{./TYPOLOGY}" />
		
			<hr />

			<div class="form-group" ng-init="newCompatibilityLevel='{$overrideCompliance}'" ng-class="{{'has-warning': newCompatibilityLevel}}">
				<label class="col-sm-3 control-label">Level of compliance</label>
				<div class="col-sm-9">
					<select class="form-control" ng-model="newCompatibilityLevel" ng-change="updateCompatibilityLevel('{$profileId}', '{$ifaceId}', newCompatibilityLevel)">
						<xsl:for-each select="//extra_info/compatibilityLevels/level">
							<option value="{.}">
								<xsl:value-of select="concat(., ' (override)')" />
							</option>
						</xsl:for-each>
						<option disabled="disabled" style="border-top: 1px solid lightgrey; margin-top: 10px;"></option>
						<option value="">
							<xsl:value-of select="concat($compliance, ' (by validator)')" />
						</option>
					</select>
				</div>
			</div>
				
			<hr />

			<wf-form-row-static name="API id" value="{$ifaceId}" />
			<wf-form-row-static name="Datasource id" value="{./DATASOURCE_ORIGINAL_ID}" />
			<wf-form-row-static name="Datasource prefix" value="{$prefix}" />
			<wf-form-row-static name="Profile" value="[link]" url="isManager.do#/profile/{$profileId}" />
			
			<xsl:if test="//extra_info/extraFields/field[@name = 'last_collection_date'] and //extra_info/extraFields/field[@name = 'last_collection_mdId'] and //extra_info/extraFields/field[@name = 'last_collection_total']">
				<hr />
				<wf-form-row-store-link name="Last collection" 
					date="{//extra_info/extraFields/field[@name = 'last_collection_date']}" 
					total="{//extra_info/extraFields/field[@name = 'last_collection_total']}" 
					url="../inspector/mdstore.do?id={//extra_info/extraFields/field[@name = 'last_collection_mdId']}" />
			</xsl:if>
		
			<xsl:if test="//extra_info/extraFields/field[@name = 'last_aggregation_date'] and //extra_info/extraFields/field[@name = 'last_aggregation_mdId'] and //extra_info/extraFields/field[@name = 'last_aggregation_total']">
				<hr />
				<wf-form-row-store-link name="Last aggregation" 
					date="{//extra_info/extraFields/field[@name = 'last_aggregation_date']}" 
					total="{//extra_info/extraFields/field[@name = 'last_aggregation_total']}" 
					url="../inspector/mdstore.do?id={//extra_info/extraFields/field[@name = 'last_aggregation_mdId']}" />
			</xsl:if>
			
			<xsl:if test="//extra_info/extraFields/field[@name = 'last_download_date'] and //extra_info/extraFields/field[@name = 'last_download_objId'] and //extra_info/extraFields/field[@name = 'last_download_total']">
				<hr />
				<wf-form-row-store-link name="Last download" 
					date="{//extra_info/extraFields/field[@name = 'last_download_date']}" 
					total="{//extra_info/extraFields/field[@name = 'last_download_total']}" 
					url="objectstoreInspector.do#/inspect.do/{//extra_info/extraFields/field[@name = 'last_download_objId']}" />
			</xsl:if>
			
			<hr />

			<div class="form-group">
				<label class="col-sm-3 control-label">Access Protocol</label>
				<div class="col-sm-9">
					<p class="form-control-static">
						<table class="table table-condensed table-striped">
							<tr>
								<th colspan="2">Protocol</th>
								<td class="col-xs-9">
									<xsl:value-of select="$protocol" />
									<xsl:if test="$protocol = 'oai' or $protocol = 'OAI'">
										<a href="oaiExplorer.do?oaiBaseUrl={$baseUrl}" class="btn btn-xs btn-primary pull-right">verify</a>
									</xsl:if>
								</td>
							</tr>
							<tr>
								<th colspan="2">Base URL</th>
								<td>
									<a href="{$baseUrl}">
										<xsl:value-of select="$baseUrl" />
									</a>
								</td>
							</tr>

							<xsl:variable name="countParams" select="count(//extra_info/parameters/param)" />
							<xsl:for-each select="//extra_info/parameters/param">
								<tr>
									<xsl:if test="position() = 1">
										<th rowspan="{$countParams}" class="col-xs-2">Parameters</th>
									</xsl:if>
									<td class="col-xs-2">
										<i>
											<xsl:value-of select="@name" />
										</i>
									</td>
									<td class="col-xs-8">
										<xsl:value-of select="." />
									</td>
								</tr>
							</xsl:for-each>
						</table>

					</p>
				</div>
			</div>
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<button type="button" class="btn btn-sm btn-primary" ng-click="editAccessParams()">configure</button>
				</div>
			</div>
	
			<hr />
	
			<div class="form-group">
				<label class="col-sm-3 control-label">API Extra fields</label>
				<div class="col-sm-9">
					<p class="form-control-static">
						<table class="table table-condensed table-striped">
							<tr>
								<th class="col-xs-4">metadata_identifier_path</th>
								<td class="col-xs-8">
									<span id="mdIdPath"><xsl:value-of select="//extra_info/extraFields/field[@name = 'metadata_identifier_path']" /></span> 
									<button type="button" class="btn btn-xs btn-primary pull-right" ng-click="updateMdIdPath('{$profileId}', '{$ifaceId}')" >edit</button>
								</td>
							</tr>
						
							<xsl:for-each select="//extra_info/extraFields/field[not(@name = 'metadata_identifier_path' or starts-with(@name, 'last_collection_') or starts-with(@name, 'last_aggregation_') or starts-with(@name, 'last_download_'))]">
								<tr>
									<th class="col-xs-4">
										<xsl:value-of select="@name" />
									</th>
									<td class="col-xs-8">
										<xsl:value-of select="." />
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</p>
				</div>
			</div>
		
			<hr />

			<div class="form-group">
				<label class="col-sm-3 control-label">Related workflows</label>
				<div class="col-sm-9">
					<p class="form-control-static">
						<xsl:choose>
							<xsl:when test="count(//workflows/workflow) = 0">
								No workflows							
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="//workflows/workflow">
									<a href="workflows.do#/wf/{@id}"><xsl:value-of select="@name" /></a>
									<xsl:if test="@destroy">
										<button class="btn btn-sm btn-primary pull-right" ng-click="destroyRepoWorkflow('{@id}')">delete</button>
									</xsl:if>
									<br />
									<xsl:if test="@description">
										<span class="small text-muted">
											<xsl:value-of select="@description"/><br />
										</span>
									</xsl:if>
									<hr />
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</p>
				</div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<xsl:variable name="definitiveCompliance">
						<xsl:choose>
							<xsl:when test="$overrideCompliance">
								<xsl:value-of select="$overrideCompliance" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$compliance" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addWorkflowModal"
						ng-click="findRepoHiWorkflows('{normalize-space($definitiveCompliance)}', '{normalize-space($typology)}')">
						add workflow
					</button>
					<button type="button" class="btn btn-sm btn-default pull-right" ng-click="refresh()">
						<span class="glyphicon glyphicon-refresh"></span>
					</button>
				</div>
			</div>
			
			<hr />
			
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<xsl:choose>
						<xsl:when test="count(//workflows/workflow) > 0">
							<button type="button" class="btn btn-sm btn-warning" onclick="alert('This Api can not be deleted (there are related workflows)')">
								delete the API
							</button>
						</xsl:when>
						<xsl:when test="$removable = 'false'">
							<button type="button" class="btn btn-sm btn-warning" onclick="alert('This Api can not be deleted (@removable is false)')">
								delete the API
							</button>																				
						</xsl:when>
						<xsl:otherwise>
							<button type="button" class="btn btn-sm btn-danger" 
								ng-click="deleteApi('{$profileId}', '{$ifaceId}')">
								delete the API
							</button>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>			
			
		</form>
				
		<wf-process-modal proc-id="currentProcId" visible="showProcModal" />
		<repo-access-params-modal ds-id="{$profileId}" iface="{$ifaceId}" protocol="{$protocol}" visible="showAccessParamsModal" reload="1" />
						
		<div id="addWorkflowModal" class="modal fade" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<xsl:text disable-output-escaping="yes"><![CDATA[&times;]]></xsl:text>
						</button>
						<h4 class="modal-title">Select workflow</h4>
					</div>
					<div class="modal-body">
						<div ng-repeat="e in availableRepohiWfs" class="panel panel-default">
							<div class="panel-heading">
								<a ng-click="newRepoWorkflow('{$profileId}', '{$ifaceId}', e.id)" data-dismiss="modal" href="javascript:void(0)">{{e.name}}</a>
								<a href="isManager.do#/profile/{{{{e.id}}}}" class="pull-right">[link]</a>
								<br /><span class="text-muted small">{{e.description}}</span>
							</div>
							<table class="table table-striped table-condensed small">
								<tr>
									<th class="col-xs-3 text-right">Typology prefixes</th>
									<td>{{e.ifaceTypes.join()}}</td>
								</tr><tr>
									<th class="col-xs-3 text-right">Compliance prefixes</th>
									<td>{{e.compliances.join()}}</td>
								</tr><tr ng-repeat="f in e.fields">
									<th class="col-xs-3 text-right">{{f.k}}</th>
									<td>{{f.v}}</td>
								</tr>
							</table>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</div>
			</div>
		</div>
	</xsl:template>

</xsl:stylesheet>
