var repoControllers = angular.module('repoControllers', []);

repoControllers.controller('repoBrowseCtrl', [
	'$scope', '$http', '$timeout', '$sce', '$location',
	function ($scope, $http, $timeout, $sce, $location) {
		common_init($scope, $http, $sce, $location);
		$scope.repoBrowseFields = getBrowseFields();
		$scope.filterBrowseData = {filterText: ''};
		$scope.repoBrowseData = {'data': []};

		$scope.gridBrowseData = {
			data: 'repoBrowseData.data',
			enableRowSelection: false,
			enableCellEditOnFocus: false,
			enableHighlighting: true,
			filterOptions: $scope.filterBrowseData,
			sortInfo: {fields: ['value'], directions: ['desc']},
			columnDefs: [
				{
					field: 'name',
					displayName: 'Name',
					cellTemplate: '<div class="ngCellText"><a href="javascript:void(0)" ng-click="browseApis(repoBrowseData.id, row.getProperty(\'id\'))">{{row.getProperty(col.field)}}</a></div>'
				},
				{field: 'value', displayName: '# datasources', width: '20%', headerClass: 'text-right', cellClass: 'text-right'}
			]
		};

		$scope.searchApis = function (text) {
			$scope.go('/list/__SEARCH__/' + text);
		}

		$scope.browseApis = function (field, value) {
			$('#showRepoBrowseData').modal('hide');
			$scope.showSpinner();
			$timeout(function () {
				$scope.go('/list/' + field + '/' + value);
			}, 1500);
		}

		$scope.browseRepoField = function (field) {
			$scope.repoBrowseData = {
				'label': field.label,
				'id': field.id,
				'data': []
			};
			$scope.showSpinner();
			$http.get('browseRepoField.do?field=' + field.id).success(
				function (data) {
					$scope.hideSpinner();
					$scope.repoBrowseData.data = data;
					$('#showRepoBrowseData').modal('show');
				}
			).error(
				function () {
					$scope.showError('Something really bad must have happened to our fellow hamster..');
					$scope.hideSpinner();
				}
			);
		};
	}
]);

repoControllers.controller('repoListCtrl', [
	'$scope', '$http', '$timeout', '$sce', '$routeParams', '$location',
	function ($scope, $http, $timeout, $sce, $routeParams, $location) {
		common_init($scope, $http, $sce, $location);

		$scope.apis = [];
		
		$scope.currentApiSelectionParam = $routeParams.param;
		$scope.currentApiSelectionValue = $routeParams.value;

		$scope.updateApis = function (refresh) {
			$scope.showSpinner();

			var params = {
				'param': $scope.currentApiSelectionParam,
				'value': $scope.currentApiSelectionValue,
			};
			if (refresh) {
				params.refresh = 1;
			}

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('listApis.do', $.param(params)).success(
				function (data) {
					$scope.hideSpinner();
					$scope.apis = data;
				}
			).error(
				function () {
					$scope.showError('Something really bad must have happened to our fellow hamster..');
					$scope.hideSpinner();
				}
			);
		};

		$scope.showApi = function (repoId, ifaceId) {
			location.href = 'workflows.do#/api/' + repoId + '/' + ifaceId;
		}

		$scope.updateApis(false);
	}
]);



