/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui;

import eu.dnetlib.functionality.modular.ui.EntryPointsAggregator;
import eu.dnetlib.functionality.modular.ui.MenuEntry;
import eu.dnetlib.functionality.modular.ui.users.AuthorizationManager;
import eu.dnetlib.functionality.modular.ui.users.User;
import eu.dnetlib.functionality.modular.ui.utils.ShutdownUtils;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.view.RedirectView;

public abstract class ModuleEntryPoint
extends MenuEntry
implements Controller,
BeanNameAware {
    @Autowired
    protected EntryPointsAggregator aggregator;
    @Resource(name="modularUiAuthorizationManager")
    protected AuthorizationManager authorizationManager;
    private String beanName;
    private boolean validMenuEntry = true;
    private String group;
    private int groupOrder = 50;
    @Value(value="${dnet.modular.ui.authentication.url}")
    private String authenticationUrl;
    @Value(value="${dnet.modular.ui.logout.url}")
    private String logoutUrl;
    @Value(value="${dnet.modular.ui.ribbon.environment}")
    private String environment;
    @Value(value="${dnet.modular.ui.ribbon.accent}")
    private String ribbonAccent;
    @Autowired
    private ShutdownUtils shutdownUtils;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = this.authorizationManager.obtainUserDetails(request);
        if (user != null) {
            ModelAndView mv = new ModelAndView();
            ModelMap map = mv.getModelMap();
            map.addAttribute("ui_menu", (Object)this.getMenu());
            map.addAttribute("ui_title", (Object)this.getTitle());
            map.addAttribute("ui_description", (Object)this.getDescription());
            map.addAttribute("ui_group", (Object)this.getGroup());
            map.addAttribute("ui_modules", this.aggregator.getMenus(user));
            map.addAttribute("environment", (Object)this.environment);
            map.addAttribute("ribbonAccent", (Object)this.ribbonAccent);
            switch (this.shutdownUtils.currentStatus()) {
                case STOPPING: {
                    map.addAttribute("ui_navbar_class", (Object)"navbar-system-stopping");
                    map.addAttribute("ui_message", (Object)"stopping system");
                    break;
                }
                case STOPPED: {
                    map.addAttribute("ui_navbar_class", (Object)"navbar-system-stopped");
                    map.addAttribute("ui_message", (Object)"system stopped");
                    break;
                }
                default: {
                    map.addAttribute("ui_navbar_class", (Object)"navbar-inverse");
                }
            }
            String baseUrl = "";
            for (int i = 1; i < StringUtils.countMatches((CharSequence)this.beanName, (CharSequence)"/"); ++i) {
                baseUrl = baseUrl + "/..";
            }
            if (baseUrl.length() > 0) {
                baseUrl = baseUrl.substring(1);
            }
            map.addAttribute("ui_baseUrl", (Object)baseUrl);
            if (this.logoutUrl != null && !this.logoutUrl.isEmpty()) {
                map.addAttribute("ui_logoutUrl", (Object)this.logoutUrl);
            }
            map.addAttribute("ui_user", (Object)user);
            this.initialize(map, request, response);
            return mv;
        }
        StringBuffer url = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append('?');
            url.append(queryString);
        }
        return new ModelAndView((View)new RedirectView(this.authenticationUrl + "?url=" + URLEncoder.encode(url.toString(), "UTF-8")));
    }

    protected abstract void initialize(ModelMap var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getGroup() {
        return this.group;
    }

    @Required
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getRelativeUrl() {
        return this.beanName;
    }

    public boolean isValidMenuEntry() {
        return this.validMenuEntry;
    }

    public void setValidMenuEntry(boolean validMenuEntry) {
        this.validMenuEntry = validMenuEntry;
    }

    public int getGroupOrder() {
        return this.groupOrder;
    }

    public void setGroupOrder(int groupOrder) {
        this.groupOrder = groupOrder;
    }
}

