var wfFormFields = angular.module("wfFormFields", []);

wfFormFields.value('availableUis', {
	LOCAL_DATABASE : [
		{ label : 'show database', url : 'dbManager.do#/db/%s', paramRequired : true }
	],
	MDSTORE_ID : [
		{ label : 'show records', url : '../inspector/mdstore.do?id=%s', paramRequired : true },
		{ label : 'show profile', url : 'isManager.do#/profile/%s',      paramRequired : true }
	],
	OBJECTSTORE_ID : [
		  { label : 'show objects', url : '../inspector/objectstore.do?id=%s', paramRequired : true },
		  { label : 'show profile', url : 'isManager.do#/profile/%s',      paramRequired : true }
	  ],
	TRANSFORMATION_RULE_ID : [
		{ label : 'register profile', url : 'isManager.do#/register',   paramRequired : false },
		{ label : 'show profile',     url : 'isManager.do#/profile/%s', paramRequired : true }
	],
	CLEANER_RULE_ID : [
		{ label : 'register profile', url : 'isManager.do#/register',   paramRequired : false },
		{ label : 'show profile',     url : 'isManager.do#/profile/%s', paramRequired : true }
	]
});

wfFormFields.service('cacheParameters', function () {
	var validParamValuesCache = {};
	
	return {
		listValidValuesForUserParam: function (func, refresh) {
			if (refresh || !validParamValuesCache[func]) {
				try {
					validParamValuesCache[func] = eval(func);
				} catch (e) {
					alert('Error evaluating function: ' + func);
					validParamValuesCache[func] = [];
				}
			}
			return validParamValuesCache[func];
		}
	};
});

wfFormFields.filter('sprintf', function () {
	function parse(str) {
		var args = [].slice.call(arguments, 1), i = 0;
		return str.replace(/%s/g, function () {
			return args[i++];
		});
	}

	return function (str) {
		return parse(str, arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
	};
});


wfFormFields.directive('bsHasError', function () {
	return {
		restrict: "A",
		link: function (scope, element, attrs, ctrl) {
			element.toggleClass('has-feedback', true);
			var input = element.find('input[ng-model], select[ng-model]');
			if (input) {
				scope.$watch(function () {
					if (input.controller('ngModel').$invalid) {
						return 0;
					} else if (!input.controller('ngModel').$viewValue) {
						return 1;
					} else {
						return 2;
					}
				}, function (code) {
					if (code < 0) return;

					element.toggleClass('has-error', (code == 0));
					element.toggleClass('has-warning', (code == 1));
					element.toggleClass('has-success', (code == 2));

					var feedback = element.find('.form-control-feedback');
					if (feedback) {
						feedback.toggleClass('glyphicon-remove', (code == 0));
						feedback.toggleClass('glyphicon-warning-sign', (code == 1));
						feedback.toggleClass('glyphicon-ok', (code == 2));
					}
				});
			}
		}
	};
});

wfFormFields.directive('wfFormRowStatic', function (availableUis) {
	return {
		restrict: 'E',
		scope: {
			name             : '@',
			value            : '@',
			description      : '@',
			valueDescription : '@',
			valueStyle       : '@',
			img              : '@',
			url              : '@',
			category         : '@'
		},
		templateUrl: '../resources/html/wf/wf-form-row-static.html',
		link: function (scope) {
			if (scope.category && availableUis[scope.category]) {
				scope.links = availableUis[scope.category];
			} else {
				scope.links = [];
			}
		}
	}
});

wfFormFields.directive('wfFormRowLabel', function () {
	return {
		restrict: 'E',
		scope: {
			name        : '@',
			value       : '@',
			description : '@',
			date        : '@',
			labelClass  : '@'
		},
		templateUrl: '../resources/html/wf/wf-form-row-label.html'
	}
});

wfFormFields.directive('wfFormRowStoreLink', function () {
	return {
		restrict: 'E',
		scope: {
			name  : '@',
			date  : '@',
			total : '@',
			url   : '@'
		},
		templateUrl: '../resources/html/wf/wf-form-row-store-link.html'
	}
});


wfFormFields.directive('wfFormRowSelect', function (cacheParameters, availableUis) {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/wf/wf-form-row-select.html',
		scope: {
			name            : '@',
			value           : '@',
			mandatory       : '@',
			description     : '@',
			initValue       : '@',
			ngModel         : '=',
			ngOriginalModel : '=',
			values          : '=',
			valuesFunction  : '@',
			category        : '@'
		},
		link: function (scope) {

			if (scope.category && availableUis[scope.category]) {
				scope.links = availableUis[scope.category];
			} else {
				scope.links = [];
			}
						
			scope.finalValues = [];

			scope.ngModel = scope.initValue;
			scope.ngOriginalModel = scope.initValue;

			scope.isRequired = (scope.mandatory == "true");

			if (scope.values) {
				scope.finalValues = scope.values;
			} else if (scope.valuesFunction) {
				scope.finalValues = cacheParameters.listValidValuesForUserParam(scope.valuesFunction);
			}
		}
	}
});

wfFormFields.directive('wfFormRowMultiSelect', function (cacheParameters, availableUis) {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/wf/wf-form-row-multi-select.html',
		scope: {
			name            : '@',
			value           : '@',
			mandatory       : '@',
			description     : '@',
			initValue       : '@',
			ngModel         : '=',
			ngOriginalModel : '=',
			values          : '=',
			valuesFunction  : '@',
			category        : '@'
		},
		link: function (scope) {

			if (scope.category && availableUis[scope.category]) {
				scope.links = availableUis[scope.category];
			} else {
				scope.links = [];
			}
			
			scope.finalValues = [];

			scope.ngModel = scope.initValue.split(',');
			scope.ngOriginalModel = scope.initValue.split(',');

			scope.isRequired = (scope.mandatory == "true");

			if (scope.values) {
				scope.finalValues = scope.values;
			} else if (scope.valuesFunction) {
				scope.finalValues = cacheParameters.listValidValuesForUserParam(scope.valuesFunction);
			}
			
			scope.refreshValues = function() {
				scope.finalValues = cacheParameters.listValidValuesForUserParam(scope.valuesFunction, true);
			}
		}
	}
});


wfFormFields.directive('wfFormRowText', function (availableUis) {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/wf/wf-form-row-text.html',
		//require: '^ngModel',
		scope: {
			name            : '@',
			mandatory       : '@',
			description     : '@',
			initValue       : '@',
			type            : '@',
			regex           : '@',
			ngModel         : '=',
			ngOriginalModel : '=',
			category        : '@'
		},
		link: function (scope) {
	
			if (scope.category && availableUis[scope.category]) {
				scope.links = availableUis[scope.category];
			} else {
				scope.links = [];
			}
			
			scope.ngModel = "";
			scope.ngOriginalModel = "";

			if (scope.initValue) {
				scope.ngModel = scope.initValue;
				scope.ngOriginalModel = scope.initValue;
			}

			scope.isRequired = (scope.mandatory == "true");
			
			if (scope.regex) {
				scope.mypattern = new RegExp(scope.regex);
			} else if (scope.type == 'boolean') {
				scope.mypattern = new RegExp("^(true|false)$");
			} else if (scope.type == 'int') {
				scope.mypattern = new RegExp("^[-+]?[0-9]+$");
			} else if (scope.type == 'float') {
				scope.mypattern = new RegExp("^[-+]?[0-9]+(\.[0-9]+)?$");
			} else if (scope.type == 'date') {
				scope.mypattern = new RegExp("^(0[1-9]|[12][0-9]|3[01])[- \/.](0[1-9]|1[012])[- \/.](19|20)\d\d$");
			} else {
				scope.mypattern = new RegExp("^.+$");
			}
		}
	}
});
