/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.oai;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.modular.ui.oai.objects.OaiRequest;
import eu.dnetlib.functionality.modular.ui.oai.objects.ResponseDetails;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OaiExplorerInternalController {
    private static final Resource oaiXslt = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/oai/xslt/oai.xslt");
    private static final Log log = LogFactory.getLog(OaiExplorerInternalController.class);
    @Autowired
    private TransformerFactory saxonTransformerFactory;

    @RequestMapping(value={"/ui/oai_verb"})
    @ResponseBody
    public String oaiVerb(@RequestBody(required=true) OaiRequest req) throws Exception {
        return this.applyXslt(this.callOaiVerb(req));
    }

    @RequestMapping(value={"/ui/test_oai_verb"})
    @ResponseBody
    public ResponseDetails testOaiVerb(@RequestBody OaiRequest req) throws Exception {
        ResponseDetails response = new ResponseDetails();
        Document doc = this.callOaiVerb(req, response);
        if (response.isValid() && doc != null) {
            OaiRequest nextCall = new OaiRequest();
            nextCall.setBaseUrl(req.getBaseUrl());
            if ("Identify".equals(req.getVerb())) {
                nextCall.setVerb("ListSets");
            } else if ("ListSets".equals(req.getVerb())) {
                nextCall.setVerb("ListMetadataFormats");
            } else if ("ListMetadataFormats".equals(req.getVerb())) {
                nextCall.setVerb("ListRecords");
                if (doc.selectSingleNode("//*[local-name()='metadataPrefix' and text()='oai_dc']") != null) {
                    nextCall.setMdf("oai_dc");
                } else {
                    nextCall.setMdf(doc.selectSingleNode("//*[local-name()='metadataPrefix']").getText());
                }
            } else if ("ListRecords".equals(req.getVerb())) {
                nextCall.setVerb("ListIdentifiers");
                nextCall.setMdf(req.getMdf());
            } else if ("ListIdentifiers".equals(req.getVerb())) {
                nextCall.setVerb("GetRecord");
                nextCall.setMdf(req.getMdf());
                nextCall.setId(doc.selectSingleNode("//*[local-name()='identifier']").getText());
            } else if ("GetRecord".equals(req.getVerb())) {
                // empty if block
            }
            response.setNextCall(nextCall);
        }
        return response;
    }

    @RequestMapping(value={"/ui/test_harvesting"})
    @ResponseBody
    public ResponseDetails testHarvesting(@RequestBody OaiRequest req) throws Exception {
        Node node;
        ResponseDetails response = new ResponseDetails();
        Document doc = this.callOaiVerb(req, response);
        if (response.isValid() && doc != null && (node = doc.selectSingleNode("//*[local-name() = 'resumptionToken']")) != null) {
            response.setSize(doc.selectNodes("//*[local-name()='" + req.getVerb() + "']/*[local-name() != 'resumptionToken']").size());
            response.setCursor(NumberUtils.toInt((String)node.valueOf("@cursor"), (int)-1));
            response.setTotal(NumberUtils.toInt((String)node.valueOf("@completeListSize"), (int)-1));
            OaiRequest nextCall = new OaiRequest();
            nextCall.setBaseUrl(req.getBaseUrl());
            nextCall.setVerb(req.getVerb());
            nextCall.setToken(node.getText());
            response.setNextCall(nextCall);
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    private InputStream callOaiVerb(OaiRequest req) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Document callOaiVerb(OaiRequest req, ResponseDetails details) {
        long start = DateUtils.now();
        Document doc = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            URIBuilder builder = new URIBuilder(req.getBaseUrl());
            builder.addParameters((List)Lists.newArrayList((Object[])req.toQueryParams()));
            HttpGet method = new HttpGet(builder.build());
            method.setHeader((Header)new BasicHeader("Content-type", "text/xml; charset=UTF-8"));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)method);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (200 != statusCode) {
                    throw new Exception("Error " + statusCode + " from  url: " + req.getBaseUrl());
                }
                details.setHttpCode(statusCode);
                details.setValid(200 == statusCode);
                doc = new SAXReader().read(response.getEntity().getContent());
            }
        }
        catch (Exception e) {
            details.setValid(false);
            details.setError(e.getMessage());
        }
        details.setTime(DateUtils.now() - start);
        details.setVerb(req.getVerb());
        return doc;
    }

    private String applyXslt(InputStream input) throws Exception {
        Transformer transformer = this.saxonTransformerFactory.newTransformer(new StreamSource(oaiXslt.getInputStream()));
        StringWriter output = new StringWriter();
        transformer.transform(new StreamSource(input), new StreamResult(output));
        return output.toString();
    }
}

