package eu.dnetlib.functionality.modular.ui.repositories.objects;

import java.util.List;
import java.util.Set;

import eu.dnetlib.miscutils.collections.Pair;

public class RepoHIWorkflow implements Comparable<RepoHIWorkflow> {

	private final String id;
	private final String name;
	private final String description;
	private final Set<String> ifaceTypes;
	private final Set<String> compliances;
	private List<Pair<String, String>> fields;

	/**
	 * Instantiates a new repo hi workflow.
	 *
	 * @param id
	 *            the id
	 * @param name
	 *            the name
	 * @param ifaceTypes
	 *            the iface types
	 * @param compliances
	 *            the compliances
	 * @param fields
	 *            the fields
	 */
	public RepoHIWorkflow(final String id, final String name, final String description, final Set<String> ifaceTypes, final Set<String> compliances,
			final List<Pair<String, String>> fields) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.ifaceTypes = ifaceTypes;
		this.compliances = compliances;
		this.fields = fields;
	}

	public String getId() {
		return this.id;
	}

	public String getName() {
		return this.name;
	}

	public String getDescription() {
		return this.description;
	}

	public Set<String> getIfaceTypes() {
		return this.ifaceTypes;
	}

	public Set<String> getCompliances() {
		return this.compliances;
	}

	@Override
	public int compareTo(final RepoHIWorkflow o) {
		return getName().compareTo(o.getName());
	}

	/**
	 * @return the fields
	 */
	public List<Pair<String, String>> getFields() {
		return this.fields;
	}

	/**
	 * @param fields
	 *            the fields to set
	 */
	public void setFields(final List<Pair<String, String>> fields) {
		this.fields = fields;
	}

}
