package eu.dnetlib.functionality.modular.ui.workflows.objects.sections;

import java.util.List;
import java.util.Set;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowItem;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowSectionGrouper {

	private static final long CACHE_DURATION = 600000; // 10 minutes
	private Set<String> cache = Sets.newHashSet();
	private long cacheDate = 0;
	@Autowired
	private ISLookupClient isLookupClient;

	public List<WorkflowItem> listWorflowsForDatasource(String dsId) {
		return isLookupClient.listWorflowsForDatasource(dsId);
	}

	public List<WorkflowItem> listWorflowsForSection(String name) {
		return isLookupClient.listWorflowsForSection(name);
	}

	public String getDatasourceName(String dsId) {
		return isLookupClient.getDatasourceName(dsId);
	}

	public Set<String> getAllSectionNames() {
		synchronized (cache) {
			if (cache.isEmpty() || DateUtils.now() - cacheDate > CACHE_DURATION) {
				cache.clear();
				cache.addAll(isLookupClient.listSimpleWorflowSections());
				cacheDate = DateUtils.now();
			}
		}

		final Set<String> res = Sets.newHashSet(cache);

		res.remove("datasources");

		return res;
	}

}
