/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.users;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.functionality.modular.ui.users.AuthorizationDAO;
import eu.dnetlib.functionality.modular.ui.users.PermissionLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MongoAuthorizationDAO
implements AuthorizationDAO {
    private DB db;
    private static final String AUTH_COLL = "users";
    private static final Log log = LogFactory.getLog(MongoAuthorizationDAO.class);

    @Override
    public void updatePermissionLevels(Map<String, Set<PermissionLevel>> map) {
        DBCollection coll = this.db.getCollection(AUTH_COLL);
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, Set<PermissionLevel>> e : map.entrySet()) {
            HashMap m = Maps.newHashMap();
            m.put("uid", e.getKey());
            m.put("levels", this.serializeLevels(e.getValue()));
            list.add(BasicDBObjectBuilder.start((Map)m).get());
        }
        coll.remove((DBObject)new BasicDBObject());
        coll.insert((List)list);
    }

    @Override
    public Map<String, Set<PermissionLevel>> getPermissionLevels() {
        DBCollection coll = this.db.getCollection(AUTH_COLL);
        DBCursor cur = coll.find();
        HashMap res = Maps.newHashMap();
        while (cur.hasNext()) {
            DBObject o = cur.next();
            res.put((String)o.get("uid"), this.readLevels(o));
        }
        return res;
    }

    @Override
    public Set<PermissionLevel> getPermissionLevels(String uid) {
        DBCollection coll = this.db.getCollection(AUTH_COLL);
        DBObject obj = coll.findOne((DBObject)new BasicDBObject("uid", (Object)uid));
        return this.readLevels(obj);
    }

    private Set<PermissionLevel> readLevels(DBObject obj) {
        Object levels;
        HashSet<PermissionLevel> set = new HashSet<PermissionLevel>();
        if (obj != null && (levels = obj.get("levels")) != null) {
            for (String s : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)levels.toString())) {
                try {
                    set.add(PermissionLevel.valueOf(s));
                }
                catch (Throwable e) {
                    log.error((Object)("Invalid permissionLevel: " + s));
                }
            }
        }
        return set;
    }

    private String serializeLevels(Set<PermissionLevel> levels) {
        return Joiner.on((String)",").skipNulls().join(levels);
    }

    public DB getDb() {
        return this.db;
    }

    @Required
    public void setDb(DB db) {
        this.db = db;
    }
}

