<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<xsl:for-each select="//*[local-name()='record']">
			<div
					style="color:black; font-family:'Courier New', Courier, monospace; font-size:small">
				<xsl:call-template name="xmlItem">
					<xsl:with-param name="indent" select="string('')" />
				</xsl:call-template>
			</div>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="xmlAttr">
		<span style='color:red'><xsl:value-of select="concat(' ', local-name())"/></span>
		<xsl:value-of select="concat('=&quot;', ., '&quot;')"/>
	</xsl:template>

	<xsl:template name="xmlItem">
		<xsl:param name="indent" />
		<xsl:variable name="tag" select="local-name()" />
		<xsl:variable name="newindent"><xsl:value-of select="$indent" />&#160;&#160;&#160;&#160;</xsl:variable>

		<xsl:if test="string-length($tag)">
			<br/><xsl:value-of select="$indent" /><span style='color:blue'><xsl:value-of select="concat('&lt;',$tag)" /></span>
			<xsl:for-each select="@*">
				<xsl:call-template name="xmlAttr"/>
			</xsl:for-each>

			<xsl:choose>
				<xsl:when test="count(child::*) = 0 and count(child::text()) = 1">
					<span style='color:blue'>&gt;</span>
					<xsl:value-of select="normalize-space(.)" />
					<span style='color:blue'><xsl:value-of select="concat('&lt;/',$tag,'&gt;')" /></span>
				</xsl:when>
				<xsl:when test="count(child::* | child::text()) &gt; 0">
					<span style='color:blue'>&gt;</span>
					<xsl:for-each select="child::* | child::text()">
						<xsl:choose>
							<xsl:when test="self::text() and string-length(normalize-space(.)) &gt; 0">
								<xsl:value-of select="normalize-space(.)" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="xmlItem">
									<xsl:with-param name="indent" select="$newindent" />
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<br /><xsl:value-of select="$indent" /><span style='color:blue'><xsl:value-of select="concat('&lt;/',$tag,'&gt;')" /></span>
				</xsl:when>
				<xsl:otherwise>
					<span style='color:blue'>&#160;/&gt;</span>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>