package eu.dnetlib.functionality.modular.ui.lightui;

import java.io.IOException;
import java.util.Map;

import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.lightui.objects.IndexConfiguration;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class LightUIUtils {

	public static Map<String, String> getBrowseFields(final Node browseNode) {

		final Map<String, String> browseFields = Maps.newLinkedHashMap();
		for (Object o : browseNode.selectNodes(".//BROWSE_FIELD")) {
			final String id = ((Element) o).valueOf("@id");
			final String label = ((Element) o).valueOf("@label");
			browseFields.put(id, label);
		}
		return browseFields;
	}

	public static IndexConfiguration calculateIndexConfiguration(final Node node) throws DocumentException, IOException {
		final String id = node.valueOf("./INDEX/@id");
		final String format = node.valueOf("./INDEX/@format");
		final String layout = node.valueOf("./INDEX/@layout");
		final String interpretation = node.valueOf("./INDEX/@interpretation");
		final String backendId = node.valueOf("./INDEX/@backendId");

		return new IndexConfiguration(id, format, layout, interpretation, backendId);
	}
}
