package eu.dnetlib.functionality.modular.ui.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

import com.google.common.base.Joiner;

public class LogUiAppender extends AppenderSkeleton {

	public static final int MAX_LOGS_IN_QUEUE = 2000;

	private final LinkedBlockingQueue<LogLine> logQueue = new LinkedBlockingQueue<>(MAX_LOGS_IN_QUEUE);

	private int count = 0;

	private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Override
	protected void append(final LoggingEvent event) {
		synchronized (this.logQueue) {
			if (this.logQueue.remainingCapacity() == 0) {
				this.logQueue.poll();
			}
			try {
				final String date = dateFormat.format(new Date(event.getTimeStamp()));

				final String[] arr = event.getThrowableStrRep();
				final String strace = arr != null && arr.length > 0 ? Joiner.on("\n").join(arr) : "";

				this.logQueue.put(new LogLine(this.count++, event.getLevel().toString(), event.getLoggerName(), date, event.getRenderedMessage(), strace));
			} catch (final InterruptedException e) {
				throw new RuntimeException(e);
			}
		}
	}

	public List<LogLine> tail_N(final int n) throws Exception {
		if (n <= 0) { return new ArrayList<>(); }

		synchronized (this.logQueue) {
			return StreamSupport
					.stream(this.logQueue.spliterator(), false)
					.skip(Math.max(0, this.logQueue.size() - n))
					.collect(Collectors.toList());
		}
	}

	public List<LogLine> tail_continue(final int after) throws Exception {
		synchronized (this.logQueue) {
			return StreamSupport
					.stream(this.logQueue.spliterator(), false)
					.filter(ll -> (ll.getId() > after))
					.collect(Collectors.toList());
		}
	}

	@Override
	public void close() {}

	@Override
	public boolean requiresLayout() {
		return false;
	}

}
