/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects;

import eu.dnetlib.functionality.modular.ui.workflows.objects.EnvParam;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class ProcessInfo {
    private String procId;
    private String wfId;
    private String name;
    private String family;
    private String status = "CREATED";
    private String datasource;
    private long date = Long.MAX_VALUE;
    private long startDate = 0L;
    private long endDate = 0L;
    private List<EnvParam> outputParams = new ArrayList<EnvParam>();
    private List<ProcessNode> processNodes = new ArrayList<ProcessNode>();

    public ProcessInfo() {
    }

    public ProcessInfo(String procId) {
        this.procId = procId;
    }

    public ProcessInfo(WorkflowProcess process) {
        this.procId = process.getId();
        this.wfId = process.getProfileId();
        this.name = process.getName();
        this.family = process.getFamily();
        this.status = process.getStatus().toString();
        this.datasource = process.getDsName();
        this.date = process.getLastActivityDate();
        this.startDate = process.getStartDate();
        this.endDate = process.getEndDate();
        process.getTokens().stream().map(t -> new ProcessNode((Token)t, process.getGraph())).forEach(this.processNodes::add);
    }

    public ProcessInfo(Map<String, String> logs) {
        if (logs == null || logs.isEmpty()) {
            return;
        }
        this.procId = logs.get("system:processId");
        this.wfId = logs.containsKey("system:profileId") ? logs.get("system:profileId") : logs.get("system:profileTemplateId");
        this.name = logs.get("system:wfName");
        this.family = logs.get("system:family");
        this.status = logs.get("system:processStatus");
        this.datasource = logs.get("datasource:name");
        this.date = NumberUtils.toLong((String)logs.get("log:date"), (long)Long.MAX_VALUE);
        this.startDate = NumberUtils.toLong((String)logs.get("system:startDate"), (long)Long.MAX_VALUE);
        this.endDate = NumberUtils.toLong((String)logs.get("system:endDate"), (long)Long.MAX_VALUE);
    }

    public String getProcId() {
        return this.procId;
    }

    public void setProcId(String processId) {
        this.procId = processId;
    }

    public String getWfId() {
        return this.wfId;
    }

    public void setWfId(String wfId) {
        this.wfId = wfId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public List<EnvParam> getOutputParams() {
        return this.outputParams;
    }

    public void setOutputParams(List<EnvParam> outputParams) {
        this.outputParams = outputParams;
    }

    public List<ProcessNode> getProcessNodes() {
        return this.processNodes;
    }

    public void setProcessNodes(List<ProcessNode> processNodes) {
        this.processNodes = processNodes;
    }

    public class ProcessNode {
        private final String id;
        private final String name;
        private final long startDate;
        private final long endDate;
        private final String status;
        private final String progress;
        private final Map<String, Object> params;
        private final Map<String, Object> envParams;

        public ProcessNode(Token t, Graph graph) {
            this.id = t.getId();
            this.name = t.getNodeName();
            this.startDate = t.getStartDate();
            this.endDate = t.getEndDate();
            this.status = t.isActive() ? "active" : (t.isFailed() ? "failed" : "done");
            this.progress = t.getProgressProvider() != null ? t.getProgressProvider().getProgressDescription() : "-";
            this.envParams = t.getEnv().getAttributes();
            this.params = graph.getNode(t.getNodeName()).resolveParams(t.getEnv());
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public long getEndDate() {
            return this.endDate;
        }

        public String getStatus() {
            return this.status;
        }

        public String getProgress() {
            return this.progress;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getEnvParams() {
            return this.envParams;
        }
    }
}

