<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="2.0"
>

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<xsl:variable name="id"   select="//*[local-name() = 'objIdentifier']" />
		
		<div class="well">
			<table>
				<tr>
					<td style="width: 120px">
						<img src="../resources/img/record.png" width="80" height="80" />
					</td>
					<td>
						<strong>Author: </strong><xsl:value-of select="//*[local-name()='creator']" /><br/>
						<strong>Title: </strong><xsl:value-of select="//*[local-name()='title']" /><br/>			
						<strong>Description: </strong><i><xsl:value-of select="//*[local-name()='description']" /></i><br/>
						<br />
						<button class="btn btn-primary btn-sm" ng-click="getDocument('objidentifier', '{$id}')">show record</button>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>
	
</xsl:stylesheet>