$common/master( header={
	<script type="text/javascript" src="../resources/js/angular.min.js"></script>
	<script type="text/javascript" src="../resources/js/vocabularies.js"></script>
	<script type="text/javascript" src="../resources/js/uniqueChecker.js"></script>
	<script type="text/javascript" src="../resources/js/modalTerm.js"></script>
	<script type="text/javascript" src="../resources/js/modalInfo.js"></script>
	<script type="text/javascript" src="../resources/js/modalSynonym.js"></script>
	<script type="text/javascript" src="../resources/js/modalRelation.js"></script>
	<script type="text/javascript">
		function getValidRelations() {
			return $if(validRelations)$$validRelations$$else$[]$endif$;
		}
	</script>
}, body={
	<div ng-app="vocabulariesUI" ng-controller="vocabulariesCtrl">
		<div class="row">
			<vocabulary-list></vocabulary-list>
			
			<div class="col-xs-12 col-sm-12 col-md-9 col-lg-9" ng-show="entries != null && selectedVocabularyIndex != null" >
				<form role="form" class="form-inline">
					<div class="btn-group">
						<button type="button" class="btn btn-default" ng-click="showInfoModal()">
							Edit info <span class="glyphicon glyphicon-book"></span>
						</button>
						<button type="button" class="btn btn-default" ng-click="showTermModal(null)">
							New Term <span class="glyphicon glyphicon-pencil"></span>
						</button>
						<button type="button" class="btn btn-default" ng-click="commit()" ng-show="!autocommit">
							Commit <span class="glyphicon glyphicon-floppy-saved"></span>
						</button>
						<button type="button" class="btn btn-default" ng-click="reloadTerms()" ng-show="!autocommit">
							Discard all <span class="glyphicon glyphicon-repeat"></span>
						</button>
						<button type="button" class="btn btn-default" ng-click="reloadTerms()" ng-show="autocommit">
                            Refresh from IS <span class="glyphicon glyphicon-refresh"></span>
                        </button>
						<button type="button" class="btn btn-default" ng-click="dropVocabulary()">
							Drop vocabulary <span class="glyphicon glyphicon-trash"></span>
						</button>
					</div>
					<div class="checkbox">
                        <label><input type="checkbox" ng-model="autocommit"> Auto-commit</label>
                    </div>
					<div class="form-group pull-right">
						<input type="text" class="form-control" ng-model="termFilter" placeholder="Filter by...">
					</div>
				</form>
				<br><br>
				
				<term-list></term-list>
			</div>
		</div>
			
		<!-- infoModal -->
		<modal-info></modal-info>
		
		<!-- term Modal -->
		<modal-term></modal-term>
		
		<!-- synonymModal -->
		<modal-synonym></modal-synonym>

		<!-- relModal -->
		<modal-relation></modal-relation>
		
	</div>
} )$
