var repoAccessParamsEditor = angular.module("repoAccessParamsEditor", ['wfFormFields']);

repoAccessParamsEditor.directive("repoAccessParamsModal", function ($http, $route) {
	return {
		restrict: 'E',
		transclude: true,
		replace:true,
		scope: {
	        'protocol'  : '@',
	        'dsId'      : '@',
	        'iface'     : '@',
	        'reload'    : '@',
	        'visible'   : '='
		},
		templateUrl: '../resources/html/wf/repo-access-params-modal.html',
		
		link: function (scope, element, attrs, ctrl) {
			
			scope.fields = [];
			
			$(element).modal({'show': false});
		
			scope.$watch(function() {
				return scope.visible;
			}, function(value) {
				if (value == true) { 
					$(element).modal('show');
					scope.visible = false;
					scope.fields = [];
					scope.params = {};
					scope.originalParams = {};
					
					showSpinner();
					
					$http.get("wf/formProtocolParameters.find?ds=" + scope.dsId + "&iface=" + scope.iface).success(
						function (data) {
							
							angular.forEach(data, function (value) {
								scope.params[value.name] = '';
								scope.originalParams[value.name] = '';
							});
							
							scope.fields = data;
							hideSpinner();
						}
					).error(
						function () {
							showError('Something really bad must have happened to our fellow hamster..');
							hideSpinner();
						}
					);
				}
			});
			
			scope.updateRepoApi = function() {
				showSpinner();
				var map = {};
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				
				var params = {};
				angular.forEach(scope.params, function (value, key) {
					if (angular.isArray(value)) {
						params[key] = value.join(',')
					} else {
						params[key] = value; 
					}
				});
				
				$http.post('repo/repoApi.update', $.param({
					'id'          : scope.dsId,
					'iface'       : scope.iface,
					'accessParams': JSON.stringify(params)
				})).success(function (data) {
					show_notification('info', 'Api correctly saved !');
					hideSpinner();
					if (scope.reload) {
						$route.reload();
					}
				}).error(function (err) {
					show_notification('error', 'Error saving access parameters: ' + err.message);
					hideSpinner();
				});
			};
			
		}
	}
});
