package eu.dnetlib.functionality.modular.ui;

import java.util.Set;

import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.functionality.modular.ui.users.AccessLimited;
import eu.dnetlib.functionality.modular.ui.users.PermissionLevel;

public abstract class MenuEntry implements Comparable<MenuEntry>, AccessLimited {

	private String menu;
	private String title;
	private String description;
	private int order = 50;
	private Set<PermissionLevel> permissionLevels;

	@Override
	public int compareTo(final MenuEntry o) {
		return NumberUtils.compare(this.getOrder(), o.getOrder());
	}

	abstract public String getRelativeUrl();

	public String getMenu() {
		return this.menu;
	}

	@Required
	public void setMenu(final String menu) {
		this.menu = menu;
	}

	public String getTitle() {
		return this.title;
	}

	@Required
	public void setTitle(final String title) {
		this.title = title;
	}

	public String getDescription() {
		return this.description;
	}

	@Required
	public void setDescription(final String description) {
		this.description = description;
	}

	@Override
	public Set<PermissionLevel> getPermissionLevels() {
		return this.permissionLevels;
	}

	@Required
	public void setPermissionLevels(final Set<PermissionLevel> permissionLevels) {
		this.permissionLevels = permissionLevels;
	}

	public int getOrder() {
		return this.order;
	}

	public void setOrder(final int order) {
		this.order = order;
	}

}
