package eu.dnetlib.functionality.modular.ui.workflows.objects;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import eu.dnetlib.msro.workflows.procs.Token;

public class NodeTokenInfo {

	private String name;
	private long start;
	private long end;
	private List<EnvParam> params;

	public NodeTokenInfo(final String name) {
		super();
		this.name = name;
		this.start = 0;
		this.end = 0;
		this.params = Lists.newArrayList();
	}

	public NodeTokenInfo(final Token token) {
		super();

		this.start = token.getStartDate();
		this.end = token.getEndDate();
		this.name = token.getNodeName();
		this.params = Lists.newArrayList();

		for (Map.Entry<String, Object> e : token.getEnv().getAttributes().entrySet()) {
			this.params.add(new EnvParam(e.getKey(), e.getValue() != null ? e.getValue().toString() : null));
		}

		Collections.sort(this.params);
	}

	public String getName() {
		return name;
	}

	public long getStart() {
		return start;
	}

	public long getEnd() {
		return end;
	}

	public List<EnvParam> getParams() {
		return params;
	}
}
