package eu.dnetlib.functionality.modular.ui.workflows.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;

import com.google.common.base.Joiner;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowNotificationInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowUpdateInfo;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants.WorkflowStatus;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class ISRegistryClient {

	private static final Log log = LogFactory.getLog(ISRegistryClient.class);
	@Autowired
	private UniqueServiceLocator serviceLocator;

	public String registerProfile(final String profile) throws ISRegistryException {
		return this.serviceLocator.getService(ISRegistryService.class).registerProfile(profile);
	}

	public void deleteProfile(final String id) throws ISRegistryException {
		this.serviceLocator.getService(ISRegistryService.class).deleteProfile(id);
	}

	public boolean updateWorkflowProfile(final String wfId, final String profile, final Map<String, Object> map) throws Exception {
		final Document doc = new SAXReader().read(new StringReader(profile));
		for (final Map.Entry<String, Object> e : map.entrySet()) {
			final Node node = doc.selectSingleNode("//CONFIGURATION/PARAMETERS/PARAM[@name='" + e.getKey() + "']");
			if (node == null) {
				log.error("Param " + e.getKey() + " not found in profile " + profile);
			} else {
				final Object val = e.getValue() != null ? e.getValue() : "";
				if (node.valueOf("@managedBy").equalsIgnoreCase("user")) {
					if(val instanceof ArrayList) {
						node.setText(Joiner.on(',').join((ArrayList<String>)val));
					}
					else node.setText(val.toString());
				} else {
					log.debug("Param " + e.getKey() + " not updated, it is not editable by user");
				}

			}
		}

		// Update the Workflow status
		if (doc.selectNodes("//CONFIGURATION/PARAMETERS/PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty()) {
			((Element) doc.selectSingleNode("//CONFIGURATION")).addAttribute("status", WorkflowStatus.EXECUTABLE.name());
		} else {
			((Element) doc.selectSingleNode("//CONFIGURATION")).addAttribute("status", WorkflowStatus.WAIT_USER_SETTINGS.name());
		}

		return this.serviceLocator.getService(ISRegistryService.class).updateProfile(wfId, doc.asXML(), doc.valueOf("//RESOURCE_TYPE/@value"));
	}

	public boolean updateWorkflowProfile(final String wfId, final String profile, final WorkflowUpdateInfo info) throws Exception {
		final Document doc = new SAXReader().read(new StringReader(profile));

		doc.selectSingleNode("//CONFIGURATION/@start").setText(info.getMode().toString());

		final Element notificationsNode = (Element) doc.selectSingleNode("//NOTIFICATIONS");
		notificationsNode.clearContent();
		if (info.getNotifications() != null) {
			for (final WorkflowNotificationInfo n : info.getNotifications()) {
				final Element emailNode = notificationsNode.addElement("EMAIL");
				emailNode.addAttribute("address", n.getEmail());
				emailNode.addAttribute("messageProfileId", n.getMessageProfileId());
				emailNode.addAttribute("condition", n.getCondition().toString());
			}
		}

		doc.selectSingleNode("//WORKFLOW_PRIORITY").setText(Integer.toString(info.getPriority()));

		final Node node = doc.selectSingleNode("//SCHEDULING");
		((Element) node).addAttribute("enabled", Boolean.toString(info.isScheduled()));
		if (info.isScheduled()) {
			node.selectSingleNode("./CRON").setText(info.getCron() != null ? info.getCron() : "");
			node.selectSingleNode("./MININTERVAL").setText(Integer.toString(info.getInterval()));
		}
		return this.serviceLocator.getService(ISRegistryService.class).updateProfile(wfId, doc.asXML(), doc.valueOf("//RESOURCE_TYPE/@value"));
	}

	public void updateWorkflowStatus(final String id, final WorkflowStatus status) throws ISRegistryException {
		this.serviceLocator.getService(ISRegistryService.class).updateProfileNode(id, "//CONFIGURATION/@status", "'" + status.toString() + "'");
	}

}
