package eu.dnetlib.functionality.modular.ui.lightui.menu;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import eu.dnetlib.functionality.modular.ui.MenuEntry;

public class LightUiMenuEntry extends MenuEntry {
		
	private String id;
	
	public LightUiMenuEntry(final String id, final String title, final String menu, final String desc, final int order) {
		setId(id);
		setTitle(title);
		setMenu(menu);
		setDescription(desc);
		setOrder(order);
	}
	
	@Override
	public String getRelativeUrl() {
		try {
			return "/ui/lightui.do?ui=" + URLEncoder.encode(getId(), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			return "javascript:void(0)";
		}
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

}
