package eu.dnetlib.functionality.modular.ui.repositories.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.ProtocolDescriptor;
import eu.dnetlib.rmi.data.ProtocolParameter;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.springframework.beans.factory.annotation.Autowired;

public class RepoUIUtils {

	private final Map<String, List<ProtocolParameter>> parametersMap = new HashMap<>();
	@Autowired
	private UniqueServiceLocator serviceLocator;

	public List<VocabularyEntry> fetchVocabularyTerms(final String voc) throws ISLookUpException {
		final String xquery = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code = '"
				+ voc.trim() + "']//TERM return concat($x/@code, ' @@@ ', $x/@english_name)";

		final List<VocabularyEntry> list = Lists.newArrayList();
		for (final String s : this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery)) {
			final String[] arr = s.split("@@@");
			list.add(new VocabularyEntry(arr[0].trim(), arr[1].trim()));
		}
		Collections.sort(list);

		return list;
	}

	public List<ProtocolParameter> listParametersForProtocol(final String protocol) {
		if (this.parametersMap.isEmpty()) {
			for (final ProtocolDescriptor d : this.serviceLocator.getService(CollectorService.class).listProtocols()) {
				this.parametersMap.put(d.getName().toLowerCase(), d.getParams());
			}
		}

		return this.parametersMap.get(protocol.toLowerCase());
	}

}
