package eu.dnetlib.functionality.modular.ui.workflows.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.math.NumberUtils;

import eu.dnetlib.msro.logging.LogMessage;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

/**
 * Created by michele on 09/11/15.
 */
public class ProcessInfo {

	public class ProcessNode {

		private final String id;
		private final String name;
		private final long startDate;
		private final long endDate;
		private final String status;
		private final String progress;
		private final Map<String, Object> params;
		private final Map<String, Object> envParams;

		public ProcessNode(final Token t, final Graph graph) {
			this.id = t.getId();
			this.name = t.getNodeName();
			this.startDate = t.getStartDate();
			this.endDate = t.getEndDate();
			this.status = t.isActive() ? "active" : t.isFailed() ? "failed" : "done";
			this.progress = t.getProgressProvider() != null ? t.getProgressProvider().getProgressDescription() : "-";
			this.envParams = t.getEnv().getAttributes();
			this.params = graph.getNode(t.getNodeName()).resolveParams(t.getEnv());
		}

		public String getId() {
			return this.id;
		}

		public String getName() {
			return this.name;
		}

		public long getStartDate() {
			return this.startDate;
		}

		public long getEndDate() {
			return this.endDate;
		}

		public String getStatus() {
			return this.status;
		}

		public String getProgress() {
			return this.progress;
		}

		public Map<String, Object> getParams() {
			return this.params;
		}

		public Map<String, Object> getEnvParams() {
			return this.envParams;
		}

	}

	private String procId;
	private String wfId;
	private String name;
	private String family;
	private String status = "CREATED";
	private String datasource;
	private long date = Long.MAX_VALUE;
	private long startDate = 0;
	private long endDate = 0;
	private List<EnvParam> outputParams = new ArrayList<>();
	private List<ProcessNode> processNodes = new ArrayList<>();

	public ProcessInfo() {}

	public ProcessInfo(final String procId) {
		this.procId = procId;
	}

	public ProcessInfo(final WorkflowProcess process) {
		this.procId = process.getId();
		this.wfId = process.getProfileId();
		this.name = process.getName();
		this.family = process.getFamily();
		this.status = process.getStatus().toString();
		this.datasource = process.getDsName();
		this.date = process.getLastActivityDate();
		this.startDate = process.getStartDate();
		this.endDate = process.getEndDate();
		process.getTokens().stream().map(t -> new ProcessNode(t, process.getGraph())).forEach(this.processNodes::add);
	}

	public ProcessInfo(final Map<String, String> logs) {
		if (logs == null || logs.isEmpty()) { return; }

		this.procId = logs.get(WorkflowsConstants.LOG_WF_PROCESS_ID);
		this.wfId = logs.containsKey(WorkflowsConstants.LOG_WF_PROFILE_ID)
				? logs.get(WorkflowsConstants.LOG_WF_PROFILE_ID)
				: logs.get(WorkflowsConstants.LOG_WF_PROFILE_TEMPLATE_ID);
		this.name = logs.get(WorkflowsConstants.LOG_WF_NAME);
		this.family = logs.get(WorkflowsConstants.LOG_WF_FAMILY);
		this.status = logs.get(WorkflowsConstants.LOG_WF_PROCESS_STATUS);
		this.datasource = logs.get(WorkflowsConstants.LOG_DATASOURCE_NAME);
		this.date = NumberUtils.toLong(logs.get(LogMessage.LOG_DATE_FIELD), Long.MAX_VALUE);
		this.startDate = NumberUtils.toLong(logs.get(WorkflowsConstants.LOG_WF_PROCESS_START_DATE), Long.MAX_VALUE);
		this.endDate = NumberUtils.toLong(logs.get(WorkflowsConstants.LOG_WF_PROCESS_END_DATE), Long.MAX_VALUE);

	}

	public String getProcId() {
		return this.procId;
	}

	public void setProcId(final String processId) {
		this.procId = processId;
	}

	public String getWfId() {
		return this.wfId;
	}

	public void setWfId(final String wfId) {
		this.wfId = wfId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getFamily() {
		return this.family;
	}

	public void setFamily(final String family) {
		this.family = family;
	}

	public String getStatus() {
		return this.status;
	}

	public void setStatus(final String status) {
		this.status = status;
	}

	public long getStartDate() {
		return this.startDate;
	}

	public void setStartDate(final long startDate) {
		this.startDate = startDate;
	}

	public long getEndDate() {
		return this.endDate;
	}

	public void setEndDate(final long endDate) {
		this.endDate = endDate;
	}

	public String getDatasource() {
		return this.datasource;
	}

	public void setDatasource(final String datasource) {
		this.datasource = datasource;
	}

	public long getDate() {
		return this.date;
	}

	public void setDate(final long date) {
		this.date = date;
	}

	public List<EnvParam> getOutputParams() {
		return this.outputParams;
	}

	public void setOutputParams(final List<EnvParam> outputParams) {
		this.outputParams = outputParams;
	}

	public List<ProcessNode> getProcessNodes() {
		return this.processNodes;
	}

	public void setProcessNodes(final List<ProcessNode> processNodes) {
		this.processNodes = processNodes;
	}

}
