package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import eu.dnetlib.rmi.data.ObjectStoreService;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by claudio on 15/06/16.
 */
public class ListDownloadPluginValues extends ValidNodeValuesFetcher {

	/** The download plugin enumerator. */

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {
		return serviceLocator.getService(ObjectStoreService.class).listDownloadPlugins()
				.stream()
				.map(p -> new DnetParamValue(p, p))
				.collect(Collectors.toList());
	}
}
