package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.springframework.beans.factory.annotation.Autowired;

public class ListProfilesValues extends ValidNodeValuesFetcher {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {
		verifyParams(params, "type", "xpath");

		final List<DnetParamValue> values = Lists.newArrayList();

		final String query = "for $x in /*[.//RESOURCE_TYPE/@value='" + params.get("type") + "']" + "return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x"
				+ params.get("xpath") + ")";

		final List<String> result = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(query);
		for (final String s : result) {
			final String[] arr = s.split("@@@");
			values.add(new DnetParamValue(arr[0].trim(), arr[1].trim()));
		}

		return values;
	}

}
