var module = angular.module('vocabulariesUI', ['uniqueChecker', 'modalTerm', 'modalInfo', 'modalSynonym', 'modalRelation']);

module.directive('vocabularyList', function(){
	return {
		restrict: 'E',
		templateUrl: '../resources/html/vocabularies/vocabulary-list.html'
	};
});

module.directive('termList', function(){
	return {
		restrict: 'E',
		templateUrl: '../resources/html/vocabularies/term-list.html'
	};
});

module.controller('vocabulariesCtrl', function ($scope, $http) {
	$scope.entries = [];
	$scope.modalSynonym = {};
	$scope.modalRel = {};
	$scope.modalTerm = {};
	$scope.modalInfo = {};
	
	$scope.validRelations = getValidRelations();

	$scope.autocommit = false;
	
	initSpinner();
	showSpinner();
	
	$scope.loadVocabularies = function() {
		$http.get('vocabularies.json')
		.success(
			function(data) {
				$scope.vocabularies = data;
				hideSpinner();
			})
		.error(
			function() {
				show_notification("error", "An error occurred while loading registered vocabulary profiles..");
				hideSpinner();
			});
	};
	
	$scope.loadVocabularies();
	
	/*---------LOAD TERMS---------*/
	$scope.loadTerms = function(vocabulary) {
		//		// check if same vocabulary
		//		if ($scope.selectedVocabularyIndex != null && vocabulary.id == $scope.vocabularies[$scope.selectedVocabularyIndex].id) {
		//			return;
		//		}
		// prompt for uncommitted changes
		if (probePermanotice() == true) {
			var r=confirm("Switching vocabulary means losing uncommitted changes.. Are you fine with that?");
			if (r == false) {
				return;
			}
		}
		//actually load terms
		showSpinner();
		$http.get('terms.json?vocabularyId=' + vocabulary.id)
			.success(
				function(data) {
					$scope.selectedVocabularyIndex = $scope.vocabularies.indexOf(vocabulary);
					$scope.entries = data;
					$scope.termFilter = "";
					hidePermanotice();
					hideSpinner();
				})
			.error(
				function() {
					show_notification("error","An error occurred while fetching terms of vocabulary d"+vocabulary.name);
					hideSpinner();
				});
	};
	
	$scope.reloadTerms = function() {
		$scope.loadTerms($scope.vocabularies[$scope.selectedVocabularyIndex]);
	};

	/*---------DELETE---------*/
	$scope.deleteTerm = function(term) {
		if ($scope.autocommit) {
			var retVal = confirm("Do you want to continue ?");
		}
		if (!$scope.autocommit || retVal == true) {
			var index = $scope.entries.indexOf(term);
			$scope.entries.splice(index, 1);
			if ($scope.autocommit) {
				$scope.commit();
			} else {
				showPermanotice("Uncommitted changes!");
			}
		}
	};

	$scope.deleteSynonym = function(term, synonym) {
		if ($scope.autocommit) {
			var retVal = confirm("Do you want to continue ?");
		}
		if (!$scope.autocommit || retVal == true) {
			var termIndex = $scope.entries.indexOf(term);
			var synonymIndex = $scope.entries[termIndex].synonyms.indexOf(synonym);
			$scope.entries[termIndex].synonyms.splice(synonymIndex, 1);
			if ($scope.autocommit) {
				$scope.commit();
			} else {
				showPermanotice("Uncommitted changes!");
			}
		}
	};
	
	$scope.deleteRel = function(term, rel) {
		if ($scope.autocommit) {
			var retVal = confirm("Do you want to continue ?");
		}
		if (!$scope.autocommit || retVal == true) {
			var termIndex = $scope.entries.indexOf(term);
			var relIndex = $scope.entries[termIndex].relations.indexOf(rel);
			$scope.entries[termIndex].relations.splice(relIndex, 1);
			if ($scope.autocommit) {
				$scope.commit();
			} else {
				showPermanotice("Uncommitted changes!");
			}
		}
	};

	$scope.dropVocabulary = function() {
		var retVal = confirm("Do you want to continue ?");
		if (retVal == true) {
			showSpinner();
			$http.get('dropVocabulary?vocabularyId=' + $scope.vocabularies[$scope.selectedVocabularyIndex].id)
				.success(
					function () {
						$scope.vocabularies.splice($scope.selectedVocabularyIndex, 1);
						$scope.selectedVocabularyIndex = null;
						show_notification("success", "Vocabulary deleted successfully!");
						hideSpinner();
					})
				.error(
					function () {
						hideSpinner();
						show_notification("error", "An error occurred while dropping vocabulary " + $scope.vocabularies[$scope.selectedVocabularyIndex].name);
					});
		}
	};

	/*---------COMMIT---------*/
	$scope.commit = function() {
		showSpinner();
		$http.post('commitVocabulary?vocabularyId=' + $scope.vocabularies[$scope.selectedVocabularyIndex].id, $scope.entries)
			.success(
				function() {
					show_notification("success", "Vocabulary successfully committed!");
					hideSpinner();
					hidePermanotice();
					if (!$scope.autocommit) {
						$scope.reloadTerms();
					}
				})
			.error(
				function() {
					show_notification("error", "An error occurred while saving the modifications..");
					showPermanotice("Uncommitted changes!");
					hideSpinner();
				});
	}
});