package eu.dnetlib.functionality.modular.ui.index.models;

import eu.dnetlib.utils.MetadataReference;

/**
 * The Class MdFormatInfo.
 */
public class MdFormatInfo {

	/** The Constant SplitCharachters. */
	private static final String SplitCharachters = "::";

	/** The id. */
	private String id;

	private MetadataReference metadataReference;

	/**
	 * The Constructor.
	 */
	public MdFormatInfo() {

	}

	/**
	 * The Constructor.
	 *
	 * @param id
	 *            the id
	 * @param format
	 *            the format
	 * @param layout
	 *            the layout
	 * @param interpretation
	 *            the interpretation
	 */
	public MdFormatInfo(final String id, final String format, final String layout, final String interpretation) {
		super();
		this.id = id;
		this.metadataReference = new MetadataReference(format, layout, interpretation);
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the id
	 */
	public void setId(final String id) {
		this.id = id;
	}

	/**
	 * Gets the format.
	 *
	 * @return the format
	 */
	public String getFormat() {
		return this.metadataReference.getFormat();
	}


	/**
	 * Gets the layout.
	 *
	 * @return the layout
	 */
	public String getLayout() {
		return this.metadataReference.getLayout();
	}


	/**
	 * Gets the interpretation.
	 *
	 * @return the interpretation
	 */
	public String getInterpretation() {
		return this.metadataReference.getInterpretation();
	}


	/**
	 * Create a new MdFormatInfo starting from the xquery result the string MUST be in this form $format-$layout-$interpretation::$id
	 *
	 * @param result
	 *            the result
	 * @return the md format info
	 */
	public static MdFormatInfo initFromXqueryResult(final String result) {
		String[] values = result.split(SplitCharachters);
		if ((values == null) || (values.length != 2)) return null;

		String[] mdref = values[0].split("-");
		if ((mdref == null) || (mdref.length != 3)) return null;

		return new MdFormatInfo(values[1], mdref[0], mdref[1], mdref[2]);

	}

}
