package eu.dnetlib.functionality.modular.ui.lightui.menu;

import java.util.List;
import java.util.Set;
import javax.annotation.Resource;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.AbstractMenu;
import eu.dnetlib.functionality.modular.ui.MenuEntry;
import eu.dnetlib.functionality.modular.ui.lightui.clients.ISLookupLightUIClient;
import eu.dnetlib.functionality.modular.ui.users.AccessLimited;
import eu.dnetlib.functionality.modular.ui.users.PermissionLevel;
import org.springframework.beans.factory.annotation.Required;

public class LightUiMenuGroup extends AbstractMenu implements AccessLimited {

	private int order;

	@Resource
	private ISLookupLightUIClient isLookupClient;
	
	@Override
	public Set<PermissionLevel> getPermissionLevels() {
		return Sets.newHashSet(PermissionLevel.USER);
	}

	@Override
	public List<? extends MenuEntry> getEntries() {
		return isLookupClient.listMenuEntries();
	}

	@Override
	public int getOrder() {
		return order;
	}

	@Required
	public void setOrder(final int order) {
		this.order = order;
	}

}
