package eu.dnetlib.functionality.modular.ui.repositories.controllers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.repositories.util.RepoUIUtils;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;

public class RepoApisEntryPointController extends ModuleEntryPoint {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private RepoUIUtils repoUIUtils;

	private String compatibilityLevelsVocabulary;

	@Override
	protected void initialize(final ModelMap map, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final Gson gson = new Gson();
		map.addAttribute("compatibilityLevels", gson.toJson(this.repoUIUtils.fetchVocabularyTerms(getCompatibilityLevelsVocabulary())));
		map.addAttribute("browseFields", gson.toJson(this.serviceLocator.getService(DatasourceManagerService.class).listBrowsableFields()));
	}

	public String getCompatibilityLevelsVocabulary() {
		return this.compatibilityLevelsVocabulary;
	}

	@Required
	public void setCompatibilityLevelsVocabulary(final String compatibilityLevelsVocabulary) {
		this.compatibilityLevelsVocabulary = compatibilityLevelsVocabulary;
	}

}
