package eu.dnetlib.functionality.modular.ui.workflows.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import eu.dnetlib.msro.workflows.graph.Graph;

public class GraphDetails {

	private List<Node> nodes = new ArrayList<>();
	private List<Arc> arcs = new ArrayList<>();

	public static GraphDetails from(final Graph graph) {
		return new GraphDetails(
				graph.nodes()
						.stream()
						.map(n -> new Node(n.getName(),
								n.isStart() ? "start" : n.isSucessNode() ? "success" : n.isJoin() ? "join" : "normal", n.getType(),
								n.resolveParams(null)))
						.collect(Collectors.toList()),
				graph.getArcs()
						.stream()
						.map(a -> new Arc(a.getName(), a.getFrom(), a.getTo()))
						.collect(Collectors.toList()));
	}

	public GraphDetails() {}

	public GraphDetails(final List<Node> nodes, final List<Arc> arcs) {
		super();
		this.nodes = nodes;
		this.arcs = arcs;
	}

	public List<Node> getNodes() {
		return this.nodes;
	}

	public List<Arc> getArcs() {
		return this.arcs;
	}

}

class Node {

	private final String name;
	private final String type;
	private final String classType;
	private final Map<String, Object> params;

	public Node(final String name, final String type, final String classType, final Map<String, Object> params) {
		super();
		this.name = name;
		this.type = type;
		this.classType = classType;
		this.params = params;
	}

	public String getName() {
		return this.name;
	}

	public String getType() {
		return this.type;
	}

	public String getClassType() {
		return this.classType;
	}

	public Map<String, Object> getParams() {
		return this.params;
	}

}

class Arc {

	private final String name;
	private final String from;
	private final String to;

	public Arc(final String name, final String from, final String to) {
		super();
		this.name = name;
		this.from = from;
		this.to = to;
	}

	public String getName() {
		return this.name;
	}

	public String getFrom() {
		return this.from;
	}

	public String getTo() {
		return this.to;
	}

}
