var module = angular.module('reposUI', ['ngGrid', 'ngRoute', 'repoControllers']);

module.config([
	'$routeProvider',
	function ($routeProvider) {
		$routeProvider
			.when('/browse', {templateUrl: '../resources/html/repoBrowse.html', controller: 'repoBrowseCtrl'})
			.when('/list/:param/:value', {templateUrl: '../resources/html/repoList.html', controller: 'repoListCtrl'})
			.otherwise({redirectTo: '/browse'});
	}
]);

module.directive('compileTemplate', function ($compile, $parse) {
	return {
		link: function (scope, element, attr) {
			var parsed = $parse(attr.ngBindHtml);

			function getStringValue() {
				return (parsed(scope) || '').toString();
			}

			//Recompile if the template changes
			scope.$watch(getStringValue, function () {
				$compile(element, null, -9999)(scope);  //The -9999 makes it skip directives so that we do not recompile ourselves
			});
		}
	}
});

module.directive('tooltip', function () {
	return {
		restrict: 'A',
		link: function (scope, element, attrs) {
			$(element).tooltip();
		}
	}
});

module.filter('sprintf', function () {
	function parse(str) {
		var args = [].slice.call(arguments, 1),
			i = 0;
		return str.replace(/%s/g, function () {
			return args[i++];
		});
	}

	return function (str) {
		return parse(str, arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
	};
});

module.directive('ngApiMdstoreInfo', function () {
	return {
		restrict: 'E',
		scope: {
			'label': '@',
			'date': '=',
			'total': '=',
			'id': '='
		},
		templateUrl: '../resources/html/ngApiMdstoreInfo.html'
	}
});

module.directive('ngApiObjectstoreInfo', function () {
	return {
		restrict: 'E',
		scope: {
			'label': '@',
			'date': '=',
			'total': '=',
			'id': '='
		},
		templateUrl: '../resources/html/ngApiObjectstoreInfo.html'
	}
});

module.directive('ngRepoCountryCell', function () {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/ngRepoCountryCell.html'
	}
});

module.directive('ngReponameCell', function () {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/ngRepoNameCell.html',
	}
});

module.directive('ngAggrDateCell', function () {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/ngAggrDateCell.html'
	}
});

module.directive('ngAggrTotalCell', function () {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/ngAggrTotalCell.html'
	}
});
