/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.utils;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.common.Stoppable;
import eu.dnetlib.enabling.common.StoppableDetails;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ShutdownUtils {
    @Autowired(required=false)
    private List<Stoppable> stoppables = Lists.newArrayList();
    private StoppableDetails.StopStatus status = StoppableDetails.StopStatus.RUNNING;
    private static final Log log = LogFactory.getLog(ShutdownUtils.class);

    public List<StoppableDetails> listStoppableDetails() {
        ArrayList list = Lists.newArrayList();
        for (Stoppable s : this.stoppables) {
            list.add(s.getStopDetails());
        }
        return list;
    }

    public void stopAll() {
        this.status = StoppableDetails.StopStatus.STOPPING;
        for (Stoppable s : this.stoppables) {
            StoppableDetails info = s.getStopDetails();
            if (info.getStatus() != StoppableDetails.StopStatus.RUNNING) continue;
            log.info((Object)("Stopping " + info.getName()));
            s.stop();
        }
    }

    public void resumeAll() {
        for (Stoppable s : this.stoppables) {
            StoppableDetails info = s.getStopDetails();
            if (info.getStatus() == StoppableDetails.StopStatus.RUNNING) continue;
            log.info((Object)("Resuming " + info.getName()));
            s.resume();
        }
        this.status = StoppableDetails.StopStatus.RUNNING;
    }

    public StoppableDetails.StopStatus currentStatus() {
        if (this.status == StoppableDetails.StopStatus.STOPPING) {
            int running = 0;
            for (Stoppable s : this.stoppables) {
                StoppableDetails info = s.getStopDetails();
                if (info.getStatus() == StoppableDetails.StopStatus.STOPPED) continue;
                ++running;
            }
            if (running == 0) {
                this.status = StoppableDetails.StopStatus.STOPPED;
            }
        }
        return this.status;
    }
}

