package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class ListDedupConfigValues extends ValidNodeValuesFetcher {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {

		final String xquery =
				"for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='DedupConfigurationDSResourceType'] return concat($x//CONFIGURATION/@id, ' @@@ ', $x//DESCRIPTION) ";

		final List<String> result = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
		final List<DnetParamValue> values = Lists.newArrayList();

		for (final String s : result) {
			final String[] arr = s.split("@@@");
			values.add(new DnetParamValue(arr[0].trim(), arr[1].trim()));
		}

		return values;
	}

}
