/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.lightui.clients;

import com.google.common.collect.Lists;
import eu.dnetlib.clients.index.client.IndexClient;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.client.ResolvingIndexClientFactory;
import eu.dnetlib.clients.index.client.response.BrowseEntry;
import eu.dnetlib.clients.index.client.response.BrowseValueEntry;
import eu.dnetlib.clients.index.client.response.LookupResponse;
import eu.dnetlib.functionality.modular.ui.lightui.objects.IndexConfiguration;
import eu.dnetlib.functionality.modular.ui.lightui.objects.SearchResult;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class IndexLightUIClient {
    private static final Log log = LogFactory.getLog(IndexLightUIClient.class);
    @Autowired
    private ResolvingIndexClientFactory indexClientFactory;
    private Map<String, IndexClient> indexClientMap;
    @Autowired
    private TransformerFactory saxonTransformerFactory;

    private List<BrowseEntry> fixBrowseEntryLabels(List<BrowseEntry> browseResult, Map<String, String> fieldLabels) {
        ArrayList fixedBrowseLabels = Lists.newArrayListWithExpectedSize((int)browseResult.size());
        for (BrowseEntry be : browseResult) {
            String fieldName = be.getLabel();
            String browsableFieldName = be.getField();
            if (fieldLabels.containsKey(fieldName)) {
                fixedBrowseLabels.add(new BrowseEntry(browsableFieldName, fieldLabels.get(fieldName), be.getValues()));
                continue;
            }
            fixedBrowseLabels.add(be);
        }
        return fixedBrowseLabels;
    }

    public List<BrowseEntry> browse(String query, IndexConfiguration idx, Map<String, String> browseFieldLabels, int max) throws IndexServiceException, DocumentException, ResultSetException {
        ArrayList<String> browseFields = new ArrayList<String>(browseFieldLabels.keySet());
        IndexClient indexClient = this.getIndexClient(idx);
        List browseResult = indexClient.browse(query, browseFields, max);
        return this.fixBrowseEntryLabels(browseResult, browseFieldLabels);
    }

    public String browse(String query, IndexConfiguration idx, Map<String, String> browseFieldLabels, int max, Resource xslt) throws IndexServiceException, DocumentException, ResultSetException {
        List<BrowseEntry> myResults = this.browse(query, idx, browseFieldLabels, max);
        int total = myResults.size();
        if (total > 0) {
            Element docRoot = DocumentHelper.createElement((String)"browse");
            Document docRes = DocumentHelper.createDocument((Element)docRoot);
            for (BrowseEntry myEntry : myResults) {
                String xpath = "./field[@name='" + myEntry.getField() + "']";
                Element f = (Element)docRoot.selectSingleNode(xpath);
                if (f == null) {
                    f = docRoot.addElement("field");
                    f.addAttribute("name", myEntry.getField());
                    f.addAttribute("label", myEntry.getLabel());
                }
                for (BrowseValueEntry valueEntry : myEntry.getValues()) {
                    Element v = f.addElement("value");
                    v.addAttribute("name", valueEntry.getValue().replaceAll("\"", "%22").replaceAll("'", "%27"));
                    v.addAttribute("size", "" + valueEntry.getSize());
                }
            }
            return new ApplyXslt(xslt, this.saxonTransformerFactory).apply((Object)docRes.asXML());
        }
        return "";
    }

    public SearchResult search(String query, IndexConfiguration idx, int page, int pageSize, Resource xslt) throws IndexServiceException, DocumentException, ResultSetException {
        log.info((Object)("executing query: " + query));
        IndexClient indexClient = this.getIndexClient(idx);
        int prod = page * pageSize;
        int from = prod - pageSize;
        int to = from + pageSize - 1;
        LookupResponse lookupResponse = indexClient.lookup(query, null, from, to);
        long total = lookupResponse.getTotal();
        StringWriter html = new StringWriter();
        ApplyXslt f = new ApplyXslt(xslt, this.saxonTransformerFactory);
        int totalPages = 0;
        if (lookupResponse.getRecords() != null) {
            for (String s : lookupResponse.getRecords()) {
                html.append(f.apply((Object)s));
            }
            totalPages = (int)lookupResponse.getTotal() / pageSize + 1;
        }
        return new SearchResult(page, totalPages, total, html.toString());
    }

    public String getDocument(IndexConfiguration idx, String field, String id, Resource xslt) throws IndexServiceException, ResultSetException {
        String query = field + " exact \"" + id.trim() + "\"";
        IndexClient indexClient = this.getIndexClient(idx);
        LookupResponse lookupResponse = indexClient.lookup(query, null, 0, 1);
        int total = (int)lookupResponse.getTotal();
        if (total != 1) {
            log.error((Object)("Invalid number of results (" + total + ") for query: " + query));
            throw new IllegalArgumentException("Invalid number of results (" + total + ") for query: " + query);
        }
        String record = (String)lookupResponse.getRecords().get(0);
        return new ApplyXslt(xslt, this.saxonTransformerFactory).apply((Object)record);
    }

    private IndexClient getIndexClient(IndexConfiguration configuration) throws IndexClientException {
        if (this.indexClientMap == null) {
            this.indexClientMap = new HashMap<String, IndexClient>();
        }
        if (this.indexClientMap.containsKey(configuration.getBackendId())) {
            return this.indexClientMap.get(configuration.getBackendId());
        }
        IndexClient index = this.indexClientFactory.getClient(configuration.getFormat(), configuration.getLayout(), configuration.getInterpretation(), configuration.getBackendId());
        this.indexClientMap.put(configuration.getBackendId(), index);
        return index;
    }
}

