package eu.dnetlib.functionality.modular.ui.vocabularies.model;

import java.util.ArrayList;
import java.util.List;

public class Term implements Comparable<Term> {
	private String englishName;
	private String nativeName;
	private String encoding;
	private String code;
	private List<Synonym> synonyms = new ArrayList<Synonym>();
	private List<Relation> relations = new ArrayList<Relation>();
	
	public Term() {}
	
	public Term(String englishName, String nativeName, String encoding,
			String code, List<Synonym> synonyms, List<Relation> relations) {
		super();
		this.englishName = englishName;
		this.nativeName = nativeName;
		this.encoding = encoding;
		this.code = code;
		this.synonyms = synonyms;
		this.relations = relations;
	}

	public String getEnglishName() {
		return englishName;
	}

	public void setEnglishName(String englishName) {
		this.englishName = englishName;
	}

	public String getNativeName() {
		return nativeName;
	}

	public void setNativeName(String nativeName) {
		this.nativeName = nativeName;
	}

	public String getEncoding() {
		return encoding;
	}

	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public List<Synonym> getSynonyms() {
		return synonyms;
	}

	public void setSynonyms(List<Synonym> synonyms) {
		this.synonyms = synonyms;
	}

	public List<Relation> getRelations() {
		return relations;
	}

	public void setRelations(List<Relation> relations) {
		this.relations = relations;
	}

	@Override
	public int compareTo(Term o) {
		return englishName.compareTo(o.getEnglishName());
	}

}
