package eu.dnetlib.functionality.modular.ui.lightui;

import java.io.StringReader;
import java.util.Map;

import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.lightui.clients.ISLookupLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.clients.IndexLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.objects.SearchResult;
import org.apache.commons.lang3.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LightUiInternalController {

	private static final int DEFAULT_MAX_BROWSE_VALUES = 20;
	private static final int DEFAULT_MAX_SINGLE_BROWSE_FIELD_VALUES = 20;
	private static final int DEFAULT_PAGESIZE = 10;

	@javax.annotation.Resource
	private IndexLightUIClient indexClient;

	@javax.annotation.Resource
	private ISLookupLightUIClient isLookupClient;

	@RequestMapping("/ui/lightui_browse")
	public
	@ResponseBody
	String browse(@RequestParam(value = "ui", required = true) final String lightuiId,
			@RequestParam(value = "query", required = true) final String query)
			throws Exception {
		final Node browseNode = getConfigurationNode(lightuiId, "//BROWSE");
		final int max = NumberUtils.toInt(browseNode.valueOf("@max"), DEFAULT_MAX_BROWSE_VALUES);
		final Resource xslt = new ClassPathResource(browseNode.valueOf("./FORMATTER/@xslt"));

		final Map<String, String> browseFields = LightUIUtils.getBrowseFields(browseNode);

		return indexClient.browse(query, LightUIUtils.calculateIndexConfiguration(browseNode), browseFields, max, xslt);
	}

	@RequestMapping("/ui/lightui_browse_one")
	public
	@ResponseBody
	String browseOne(@RequestParam(value = "ui", required = true) final String lightuiId,
			@RequestParam(value = "query", required = true) final String query,
			@RequestParam(value = "field", required = true) final String field,
			@RequestParam(value = "label", required = true) final String label) throws Exception {

		final Node browseNode = getConfigurationNode(lightuiId, "//BROWSE_SINGLE_FIELD");
		final int max = NumberUtils.toInt(browseNode.valueOf("@max"), DEFAULT_MAX_SINGLE_BROWSE_FIELD_VALUES);

		final Resource xslt = new ClassPathResource(browseNode.valueOf("./FORMATTER/@xslt"));
		final Map<String, String> browseFields = Maps.newHashMap();
		browseFields.put(field, label);

		return indexClient.browse(query, LightUIUtils.calculateIndexConfiguration(browseNode), browseFields, max, xslt);
	}

	@RequestMapping("/ui/lightui_search")
	public
	@ResponseBody
	SearchResult search(@RequestParam(value = "ui", required = true) final String lightuiId,
			@RequestParam(value = "query", required = true) final String query,
			@RequestParam(value = "page", required = true) final int page) throws Exception {

		final Node searchNode = getConfigurationNode(lightuiId, "//SEARCH");
		final Resource xslt = new ClassPathResource(searchNode.valueOf("./FORMATTER/@xslt"));
		final int pageSize = NumberUtils.toInt(searchNode.valueOf("@pageSize"), DEFAULT_PAGESIZE);

		return indexClient.search(query, LightUIUtils.calculateIndexConfiguration(searchNode), page, pageSize, xslt);
	}

	@RequestMapping("/ui/lightui_findone")
	public
	@ResponseBody
	String getDocument(@RequestParam(value = "ui", required = true) final String lightuiId,
			@RequestParam(value = "field", required = true) final String field,
			@RequestParam(value = "id", required = true) final String id) throws Exception {
		final Node searchNode = getConfigurationNode(lightuiId, "//DOCUMENT");
		final Resource xslt = new ClassPathResource(searchNode.valueOf("./FORMATTER/@xslt"));

		return indexClient.getDocument(LightUIUtils.calculateIndexConfiguration(searchNode), field, id, xslt);
	}

	private Node getConfigurationNode(final String lightuiId, final String xpath) throws Exception {
		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(new StringReader(isLookupClient.getLightUiProfile(lightuiId)));
		return doc.selectSingleNode(xpath);
	}

}
