package eu.dnetlib.functionality.modular.ui.lightui.clients;

import java.util.ArrayList;
import java.util.List;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.lightui.menu.LightUiMenuEntry;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ISLookupLightUIClient {

	private static final Log log = LogFactory.getLog(ISLookupLightUIClient.class);
	@Autowired
	private UniqueServiceLocator serviceLocator;

	public List<LightUiMenuEntry> listMenuEntries() {
		final String xQuery = "for $x in collection('/db/DRIVER/LightUiDSResources/LightUiDSResourceType') order by $x//UI_NAME "
				+ "return concat ($x//UI_NAME/@id, '§§§', $x//UI_NAME, '§§§', $x//UI_DESCRIPTION)";
		List<LightUiMenuEntry> result = new ArrayList<>();
		try {
			List<String> uiProfiles = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xQuery);
			int i = 1;
			for (String profile : uiProfiles) {
				String[] tokens = profile.split("§§§");
				result.add(new LightUiMenuEntry(tokens[0].trim(), tokens[1].trim(), tokens[1].trim(), tokens[2].trim(), i++));
			}
			return result;
		} catch (ISLookUpException e) {
			log.error("Error calculating lightui menu entries", e);
			return result;
		}
	}

	public String getLightUiProfile(final String lightuiId) throws ISLookUpException {
		String xQuery = "for $x in collection('/db/DRIVER/LightUiDSResources/LightUiDSResourceType') where $x//UI_NAME/@id = '{id}' return $x";
		return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery.replace("{id}", lightuiId));
	}

}
