package eu.dnetlib.functionality.modular.ui.lightui.objects;

import java.io.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.modular.ui.lightui.LightUIUtils;
import eu.dnetlib.functionality.modular.ui.lightui.clients.ISLookupLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.clients.IndexLightUIClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SearchFieldGrouper {

	private static final int maxBrowseValues = 100;
	private static final Log log = LogFactory.getLog(SearchFieldGrouper.class);
	@Resource
	private IndexLightUIClient indexClient;
	@Resource
	private ISLookupLightUIClient isLookupClient;

	public List<SearchField> getAllFields(final String lightuiId) {
		final List<SearchField> res = Lists.newArrayList();
		final SAXReader reader = new SAXReader();
		try {
			final Document doc = reader.read(new StringReader(isLookupClient.getLightUiProfile(lightuiId)));
			final Node searchNode = doc.selectSingleNode("//CONFIGURATION/SEARCH");
			final IndexConfiguration idx = LightUIUtils.calculateIndexConfiguration(searchNode);
			res.addAll(getPredefinedFields(searchNode));
			res.addAll(calculateBrowseFields(idx, searchNode));
		} catch (Exception e) {
			log.error("Error obtaining search fields", e);
		}
		return res;
	}

	private List<SearchField> calculateBrowseFields(final IndexConfiguration idx, final Node node) {
		try {
			return indexClient.browse("*=*", idx, LightUIUtils.getBrowseFields(node), maxBrowseValues)
					.stream()
					.map(r -> {
						final SearchField sf = new SearchField();
						sf.setField(r.getField());
						sf.setLabel(r.getLabel());
						sf.setOperator("exact");
						sf.setPredefinedValues(
								r.getValues().stream()
										.map(bv -> new ValueWithLabel(bv.getValue() + " (" + bv.getSize() + ")", bv.getValue()))
										.collect(Collectors.toList()));
						return sf;
					})
					.collect(Collectors.toList());

		} catch (Exception e) {
			log.warn("Error executing default browse query", e);
			return Lists.newArrayList();
		}
	}

	private List<SearchField> getPredefinedFields(final Node node) {
		final List<SearchField> list = Lists.newArrayList();

		for (Object o : node.selectNodes(".//TEXT_FIELD")) {
			final String id = ((Element) o).valueOf("@id");
			final String label = ((Element) o).valueOf("@label");
			final String operator = ((Element) o).valueOf("@operator");
			list.add(new SearchField(id, label, operator));
		}

		for (Object o : node.selectNodes(".//SELECT_FIELD")) {
			final String id = ((Element) o).valueOf("@id");
			final String label = ((Element) o).valueOf("@label");
			final String operator = ((Element) o).valueOf("@operator");

			final List<ValueWithLabel> values = Lists.newArrayList();
			for (Object v : ((Element) o).selectNodes("./VALUE")) {
				final String v_id = ((Element) v).valueOf("@id");
				final String v_label = ((Element) v).valueOf("@label");
				values.add(new ValueWithLabel(v_label, v_id));
			}
			list.add(new SearchField(id, label, operator, values));
		}

		return list;
	}

}
