package eu.dnetlib.functionality.modular.ui.repositories.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import eu.dnetlib.functionality.modular.ui.repositories.util.RepoUIUtils;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.ProtocolDescriptor;
import eu.dnetlib.rmi.data.ProtocolParameter;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;

public class AddRepoApiEntryPointController extends ModuleEntryPoint {

	private String datasourceTypeVocabulary;
	private String complianceVocabulary;
	private String contentDescriptionsVocabulary;
	private String protocolsVocabulary;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private RepoUIUtils repoUIUtils;

	@Override
	protected void initialize(final ModelMap map, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final Gson gson = new Gson();
		map.addAttribute("types", gson.toJson(this.repoUIUtils.fetchVocabularyTerms(this.datasourceTypeVocabulary)));
		map.addAttribute("compliances", gson.toJson(this.repoUIUtils.fetchVocabularyTerms(this.complianceVocabulary)));
		map.addAttribute("contentDescriptions", gson.toJson(this.repoUIUtils.fetchVocabularyTerms(this.contentDescriptionsVocabulary)));
		map.addAttribute("protocols", gson.toJson(listProtocols()));
	}

	private List<ProtocolDescriptor> listProtocols() throws ISLookUpException {
		final Map<String, List<ProtocolParameter>> mapParams = Maps.newHashMap();
		for (final ProtocolDescriptor pd : this.serviceLocator.getService(CollectorService.class).listProtocols()) {
			mapParams.put(pd.getName().trim().toLowerCase(), pd.getParams());
		}

		return Lists.transform(this.repoUIUtils.fetchVocabularyTerms(this.protocolsVocabulary), new Function<VocabularyEntry, ProtocolDescriptor>() {

			@Override
			public ProtocolDescriptor apply(final VocabularyEntry e) {
				final ProtocolDescriptor pd = new ProtocolDescriptor();
				pd.setName(e.getName());
				if (mapParams.containsKey(e.getName().toLowerCase().trim())) {
					pd.setParams(mapParams.get(e.getName().toLowerCase().trim()));
				} else {
					pd.setParams(new ArrayList<ProtocolParameter>());
				}
				return pd;
			}

		});
	}

	public String getDatasourceTypeVocabulary() {
		return this.datasourceTypeVocabulary;
	}

	@Required
	public void setDatasourceTypeVocabulary(final String datasourceTypeVocabulary) {
		this.datasourceTypeVocabulary = datasourceTypeVocabulary;
	}

	public String getComplianceVocabulary() {
		return this.complianceVocabulary;
	}

	@Required
	public void setComplianceVocabulary(final String complianceVocabulary) {
		this.complianceVocabulary = complianceVocabulary;
	}

	public String getContentDescriptionsVocabulary() {
		return this.contentDescriptionsVocabulary;
	}

	@Required
	public void setContentDescriptionsVocabulary(final String contentDescriptionsVocabulary) {
		this.contentDescriptionsVocabulary = contentDescriptionsVocabulary;
	}

	public String getProtocolsVocabulary() {
		return this.protocolsVocabulary;
	}

	@Required
	public void setProtocolsVocabulary(final String protocolsVocabulary) {
		this.protocolsVocabulary = protocolsVocabulary;
	}

}
