package eu.dnetlib.functionality.modular.ui.repositories.controllers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.repositories.util.RepoUIUtils;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.msro.workflows.procs.WorkflowExecutor;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.ProtocolParameterValue;
import eu.dnetlib.rmi.datasource.*;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RepoInternalController extends AbstractAjaxController {

	private static final Log log = LogFactory.getLog(RepoInternalController.class);
	@Autowired
	private UniqueServiceLocator serviceLocator;
	@Autowired
	private WorkflowSectionGrouper workflowSectionGrouper;
	@Autowired
	private WorkflowExecutor workflowExecutor;
	@Autowired
	private RepoUIUtils repoUIUtils;
	@Resource(name = "repoUIJsonCache")
	private Cache repoUIJsonCache;

	@RequestMapping(value = "/ui/browseRepoField.do")
	public @ResponseBody List<BrowseTerm> browseRepoField(@RequestParam(value = "field", required = true) final String field) throws Exception {
		return this.serviceLocator.getService(DatasourceManagerService.class).browseField(field);
	}

	@SuppressWarnings("unchecked")
	@RequestMapping(value = "/ui/listApis.do")
	public @ResponseBody List<SearchInterfacesEntry> listApis(
			@RequestParam(value = "param", required = true) final String param,
			@RequestParam(value = "value", required = true) final String value,
			@RequestParam(value = "refresh", required = false) final String refresh) throws Exception {

		final String cacheKey = "list@@@" + param + "@@@" + value;

		final Element elem = this.repoUIJsonCache.get(cacheKey);

		if (elem != null && refresh == null) {
			return (List<SearchInterfacesEntry>) elem.getObjectValue();
		} else {
			log.info("Refreshing " + cacheKey + " cache...");
			final List<SearchInterfacesEntry> list = this.serviceLocator.getService(DatasourceManagerService.class).searchInterface(param, value);
			this.repoUIJsonCache.put(new Element(cacheKey, list));
			return list;
		}
	}

	@RequestMapping(value = "/ui/listRepositories.map")
	public @ResponseBody List<RepositoryMapEntry> listRepositories_asMap() throws Exception {
		return this.serviceLocator.getService(DatasourceManagerService.class).getRepositoryMap();
	}

	@RequestMapping(value = "/ui/listRepositories.json")
	public @ResponseBody List<SimpleDatasourceDesc> listRepositories(@RequestParam(value = "type", required = true) final String type) throws Exception {
		return this.serviceLocator.getService(DatasourceManagerService.class).simpleListDatasourcesByType(type);
	}

	@SuppressWarnings("unchecked")
	@RequestMapping("/ui/repo/repoApi.update")
	public @ResponseBody boolean updateRepoApi(
			@RequestParam(value = "id", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final String ifaceId,
			@RequestParam(value = "accessParams", required = true) final String accessParamsJson) throws Exception {
		if (!StringUtils.isEmpty(accessParamsJson)) {
			this.serviceLocator.getService(DatasourceManagerService.class).bulkUpdateApiAccessParams(repoId, ifaceId,
					new Gson().fromJson(accessParamsJson, Map.class));
		}
		return true;
	}

	@RequestMapping("/ui/repo/repoApiCompliance.update")
	public @ResponseBody boolean updateRepoApiCompliance(@RequestParam(value = "id", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final String ifaceId,
			@RequestParam(value = "compliance", required = true) final String compliance) throws Exception {

		log.debug("SET COMPLIANCE TO " + compliance);

		this.serviceLocator.getService(DatasourceManagerService.class).overrideCompliance(repoId, ifaceId, compliance);

		this.repoUIJsonCache.removeAll();

		return true;
	}

	@RequestMapping("/ui/repo/repoApiCompliance.reset")
	public @ResponseBody boolean resetRepoApiCompliance(@RequestParam(value = "id", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final String ifaceId) throws Exception {

		log.debug("RESET COMPLIANCE");

		this.serviceLocator.getService(DatasourceManagerService.class).overrideCompliance(repoId, ifaceId, null);

		this.repoUIJsonCache.removeAll();

		return true;
	}

	@RequestMapping("/ui/repoApi.new")
	public @ResponseBody boolean addRepoApi(@RequestParam(value = "repoId", required = true) final String repoId,
			@RequestParam(value = "iface", required = true) final String ifaceJson) throws DatasourceManagerServiceException {
		final IfaceDesc iface = new Gson().fromJson(ifaceJson, IfaceDesc.class);

		log.info("Adding interface " + iface.getId() + " to repository " + repoId);

		final DatasourceManagerService dsManager = this.serviceLocator.getService(DatasourceManagerService.class);
		return dsManager.addInterface(repoId, iface);
	}

	@RequestMapping("/ui/repo.new")
	public @ResponseBody boolean addRepoApi(@RequestParam(value = "repo", required = true) final String repoJson) throws DatasourceManagerServiceException {
		final DatasourceDesc ds = new Gson().fromJson(repoJson, DatasourceDesc.class);
		ds.setDateOfCollection(new Date());

		//This logic has been embedded when converting DatasourceDesc into a datasource XML profile in class eu.dnetlib.enabling.datasources.DatasourceDescToProfile
//		if (StringUtils.isBlank(ds.getEnglishName())) {
//			ds.setEnglishName(ds.getOfficialName());
//		}

		log.info("Adding datasource " + ds.getId() + " - name " + ds.getOfficialName());

		final DatasourceManagerService dsManager = this.serviceLocator.getService(DatasourceManagerService.class);

		return dsManager.addDatasource(ds);
	}

	@RequestMapping("/ui/listValidValuesForParam.do")
	public @ResponseBody List<ProtocolParameterValue> listValidValuesForParam(
			@RequestParam(value = "protocol", required = true) final String protocol,
			@RequestParam(value = "param", required = true) final String param,
			@RequestParam(value = "baseUrl", required = true) final String baseUrl) throws CollectorServiceException {

		return this.serviceLocator.getService(CollectorService.class).listValidValuesForParam(protocol, baseUrl, param, null);
	}
}
