/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui;

import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.utils.LogLine;
import eu.dnetlib.functionality.modular.ui.utils.LogUiAppender;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DnetLogAjaxController
extends AbstractAjaxController {
    private LogUiAppender appender;
    private static final Log log = LogFactory.getLog(DnetLogAjaxController.class);

    @PostConstruct
    void init() throws IOException {
        this.appender = this.findLogUiAppender();
    }

    private LogUiAppender findLogUiAppender() {
        Object app;
        Logger logger = LogManager.getRootLogger();
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            app = appenders.nextElement();
            if (!(app instanceof LogUiAppender)) continue;
            log.info((Object)"An istance of LogUiAppender is already registered in log4j configuration.");
            return (LogUiAppender)((Object)app);
        }
        app = new LogUiAppender();
        LogManager.getRootLogger().addAppender(app);
        log.info((Object)"A new LogUiAppender has been registered in log4j configuration.");
        return app;
    }

    @RequestMapping(value={"/ui/log/tail/{n}"})
    @ResponseBody
    public List<LogLine> tail_N(@PathVariable(value="n") int n) throws Exception {
        return this.appender.tail_N(n);
    }

    @RequestMapping(value={"/ui/log/continue/{after}"})
    @ResponseBody
    public List<LogLine> tail_continue(@PathVariable(value="after") int after) throws Exception {
        return this.tail_continue(after, 0);
    }

    private List<LogLine> tail_continue(int after, int recursionLevel) throws Exception {
        List<LogLine> res = this.appender.tail_continue(after);
        if (res.isEmpty() && recursionLevel < 10) {
            Thread.sleep(10000L);
            return this.tail_continue(after, recursionLevel + 1);
        }
        return res;
    }

    @RequestMapping(value={"/ui/log/level/{level}/{resource}"})
    @ResponseBody
    public boolean updateLogLevel(@PathVariable(value="level") String level, @PathVariable(value="resource") String resource) throws Exception {
        if (resource != null && level != null) {
            LogManager.getLogger((String)resource).setLevel(Level.toLevel((String)level));
        }
        return true;
    }
}

