var module = angular.module('wfJournalUI', ['ngGrid', 'wfProcessViewer', 'ui.bootstrap']);

module.controller('wfJournalCtrl', function($scope, $http, $sce) {
	//commonInitialize($scope, $http, $sce);
	
	initSpinner();

	$scope.journal = [];
	
	$scope.currentId = '';
	$scope.showModal = false;
	
	$scope.family = getFamily();
	$scope.filterJournal = {filterText: ''};

	$scope.endDate = new Date();
	$scope.startDate = new Date();

	// Set date range to [7 days before today, today] inclusive
	$scope.startDate.setDate($scope.endDate.getDate() - 7);

	// Grid configuration
	$scope.gridWfJournal = {
		data: 'journal',
		enableCellSelection: false,
		enableRowSelection: false,
		enableCellEditOnFocus: false,
		enablePaging: false,
		enableHighlighting: true,
		sortInfo: {fields: ['date'], directions: ['desc']},
		filterOptions: $scope.filterJournal,
		columnDefs: [
			{
				field: 'procId',
				displayName: 'Process ID',
				width: '15%',
				cellTemplate: '<div class="ngCellText"><a href="javascript:void(0)" ng-click="showProcess(row.getProperty(col.field))">{{row.getProperty(col.field)}}</a></div>'
			},
			{field: 'name', displayName: 'Workflow name', width: '20%'},
			{field: 'family', displayName: 'Workflow family', width: '15%'},
			{field: 'datasource', displayName: 'Datasource'},
			{
				field: 'status',
				displayName: 'Status',
				width: '10%',
				headerClass: 'text-center',
				cellTemplate: '<div class="ngCellText text-center"><span class="label label-default" ng-class="{ \'label-success\': row.getProperty(col.field) == \'SUCCESS\', \'label-danger\': row.getProperty(col.field) == \'FAILURE\', \'label-info\': row.getProperty(col.field) == \'EXECUTING\'}">{{row.getProperty(col.field)}}</span></div>'
			},
			{
				field: 'date',
				displayName: 'Date',
				width: '10%',
				headerClass: 'text-right',
				cellTemplate: '<div class="ngCellText text-right">{{ (row.getProperty("date") > 0 && row.getProperty("date") < 9999999999999) ? (row.getProperty("date") | date:"yyyy-MM-dd HH:mm:ss") : "not yet started" }}</div>'
			}
		]
	};
		
	$scope.popupFrom = { opened: false };	
	$scope.popupTo   = { opened: false };	
	$scope.openPopupFrom = function() { $scope.popupFrom.opened = true; };
	$scope.openPopupTo   = function() { $scope.popupTo.opened = true; };
		
	$scope.dateOptions = {
		maxDate     : new Date(),
		minDate     : new Date(2014, 1, 1),
		startingDay : 1
	};
		
	$scope.showProcess = function(procId) {
		$scope.currentId =  procId;
		$scope.showModal = true;
	}

	$scope.formatDate = function (date) {
		if (date) {
			var year = date.getFullYear();
			var month = ("00" + (date.getMonth() + 1)).slice(-2);
			var day = ("00" + date.getDate()).slice(-2);
			return year + '-' + month + '-' + day;
		} else {
			return '';
		}
	}
	
	$scope.isValidRange = function() {
		return ($scope.startDate && $scope.endDate && $scope.startDate.getTime() <= $scope.endDate.getTime());
	};

	$scope.refresh = function () {
		if (!$scope.isValidRange()) {
			$scope.journal = [];
			return;
		}
		showSpinner();
		$scope.current = {};
		$scope.currentParam = {};
		var url = '';

		if ($scope.family) {
			url = 'wf/journal_byFamily.find?family=' + $scope.family;
		} else {
			url = 'wf/journal.range?start=' + $scope.formatDate($scope.startDate) + '&end=' + $scope.formatDate($scope.endDate);
		}
		$http.get(url).success(
			function (data) {
				$scope.journal = data;
				hideSpinner();
			}
		).error(
			function () {
				showError('Something really bad must have happened to our fellow hamster..');
				hideSpinner();
			}
		);
	}
	
	$scope.resizeMainElement = function (elem) {
		var height = 0;
		var body = window.document.body;
		if (window.innerHeight) {
			height = window.innerHeight;
		} else if (body.parentElement.clientHeight) {
			height = body.parentElement.clientHeight;
		} else if (body && body.clientHeight) {
			height = body.clientHeight;
		}
		elem.style.height = ((height - elem.offsetTop - 280) + "px");
	}

	$scope.refresh();
	$scope.resizeMainElement(document.getElementById('wfJournalTable'));

	if (initProcId()) {
		$scope.showProcess(initProcId());
	}
});

window.onresize = function () {
	var elem = document.getElementById('wfJournalTable');
	angular.element(elem).scope().resizeMainElement(elem);
};