/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.lightui;

import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.lightui.LightUIUtils;
import eu.dnetlib.functionality.modular.ui.lightui.clients.ISLookupLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.clients.IndexLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.objects.SearchResult;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LightUiInternalController {
    private static final int DEFAULT_MAX_BROWSE_VALUES = 20;
    private static final int DEFAULT_MAX_SINGLE_BROWSE_FIELD_VALUES = 20;
    private static final int DEFAULT_PAGESIZE = 10;
    @Resource
    private IndexLightUIClient indexClient;
    @Resource
    private ISLookupLightUIClient isLookupClient;

    @RequestMapping(value={"/ui/lightui_browse"})
    @ResponseBody
    public String browse(@RequestParam(value="ui", required=true) String lightuiId, @RequestParam(value="query", required=true) String query) throws Exception {
        Node browseNode = this.getConfigurationNode(lightuiId, "//BROWSE");
        int max = NumberUtils.toInt((String)browseNode.valueOf("@max"), (int)20);
        ClassPathResource xslt = new ClassPathResource(browseNode.valueOf("./FORMATTER/@xslt"));
        Map<String, String> browseFields = LightUIUtils.getBrowseFields(browseNode);
        return this.indexClient.browse(query, LightUIUtils.calculateIndexConfiguration(browseNode), browseFields, max, (org.springframework.core.io.Resource)xslt);
    }

    @RequestMapping(value={"/ui/lightui_browse_one"})
    @ResponseBody
    public String browseOne(@RequestParam(value="ui", required=true) String lightuiId, @RequestParam(value="query", required=true) String query, @RequestParam(value="field", required=true) String field, @RequestParam(value="label", required=true) String label) throws Exception {
        Node browseNode = this.getConfigurationNode(lightuiId, "//BROWSE_SINGLE_FIELD");
        int max = NumberUtils.toInt((String)browseNode.valueOf("@max"), (int)20);
        ClassPathResource xslt = new ClassPathResource(browseNode.valueOf("./FORMATTER/@xslt"));
        HashMap browseFields = Maps.newHashMap();
        browseFields.put(field, label);
        return this.indexClient.browse(query, LightUIUtils.calculateIndexConfiguration(browseNode), browseFields, max, (org.springframework.core.io.Resource)xslt);
    }

    @RequestMapping(value={"/ui/lightui_search"})
    @ResponseBody
    public SearchResult search(@RequestParam(value="ui", required=true) String lightuiId, @RequestParam(value="query", required=true) String query, @RequestParam(value="page", required=true) int page) throws Exception {
        Node searchNode = this.getConfigurationNode(lightuiId, "//SEARCH");
        ClassPathResource xslt = new ClassPathResource(searchNode.valueOf("./FORMATTER/@xslt"));
        int pageSize = NumberUtils.toInt((String)searchNode.valueOf("@pageSize"), (int)10);
        return this.indexClient.search(query, LightUIUtils.calculateIndexConfiguration(searchNode), page, pageSize, (org.springframework.core.io.Resource)xslt);
    }

    @RequestMapping(value={"/ui/lightui_findone"})
    @ResponseBody
    public String getDocument(@RequestParam(value="ui", required=true) String lightuiId, @RequestParam(value="field", required=true) String field, @RequestParam(value="id", required=true) String id) throws Exception {
        Node searchNode = this.getConfigurationNode(lightuiId, "//DOCUMENT");
        ClassPathResource xslt = new ClassPathResource(searchNode.valueOf("./FORMATTER/@xslt"));
        return this.indexClient.getDocument(LightUIUtils.calculateIndexConfiguration(searchNode), field, id, (org.springframework.core.io.Resource)xslt);
    }

    private Node getConfigurationNode(String lightuiId, String xpath) throws Exception {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(this.isLookupClient.getLightUiProfile(lightuiId)));
        return doc.selectSingleNode(xpath);
    }
}

