/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories.controllers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import eu.dnetlib.functionality.modular.ui.repositories.util.RepoUIUtils;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.ProtocolDescriptor;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;

public class AddRepoApiEntryPointController
extends ModuleEntryPoint {
    private String datasourceTypeVocabulary;
    private String complianceVocabulary;
    private String contentDescriptionsVocabulary;
    private String protocolsVocabulary;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private RepoUIUtils repoUIUtils;

    @Override
    protected void initialize(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gson gson = new Gson();
        map.addAttribute("types", (Object)gson.toJson(this.repoUIUtils.fetchVocabularyTerms(this.datasourceTypeVocabulary)));
        map.addAttribute("compliances", (Object)gson.toJson(this.repoUIUtils.fetchVocabularyTerms(this.complianceVocabulary)));
        map.addAttribute("contentDescriptions", (Object)gson.toJson(this.repoUIUtils.fetchVocabularyTerms(this.contentDescriptionsVocabulary)));
        map.addAttribute("protocols", (Object)gson.toJson(this.listProtocols()));
    }

    private List<ProtocolDescriptor> listProtocols() throws ISLookUpException {
        final HashMap mapParams = Maps.newHashMap();
        for (ProtocolDescriptor pd : ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listProtocols()) {
            mapParams.put(pd.getName().trim().toLowerCase(), pd.getParams());
        }
        return Lists.transform(this.repoUIUtils.fetchVocabularyTerms(this.protocolsVocabulary), (Function)new Function<VocabularyEntry, ProtocolDescriptor>(){

            public ProtocolDescriptor apply(VocabularyEntry e) {
                ProtocolDescriptor pd = new ProtocolDescriptor();
                pd.setName(e.getName());
                if (mapParams.containsKey(e.getName().toLowerCase().trim())) {
                    pd.setParams((List)mapParams.get(e.getName().toLowerCase().trim()));
                } else {
                    pd.setParams(new ArrayList());
                }
                return pd;
            }
        });
    }

    public String getDatasourceTypeVocabulary() {
        return this.datasourceTypeVocabulary;
    }

    @Required
    public void setDatasourceTypeVocabulary(String datasourceTypeVocabulary) {
        this.datasourceTypeVocabulary = datasourceTypeVocabulary;
    }

    public String getComplianceVocabulary() {
        return this.complianceVocabulary;
    }

    @Required
    public void setComplianceVocabulary(String complianceVocabulary) {
        this.complianceVocabulary = complianceVocabulary;
    }

    public String getContentDescriptionsVocabulary() {
        return this.contentDescriptionsVocabulary;
    }

    @Required
    public void setContentDescriptionsVocabulary(String contentDescriptionsVocabulary) {
        this.contentDescriptionsVocabulary = contentDescriptionsVocabulary;
    }

    public String getProtocolsVocabulary() {
        return this.protocolsVocabulary;
    }

    @Required
    public void setProtocolsVocabulary(String protocolsVocabulary) {
        this.protocolsVocabulary = protocolsVocabulary;
    }
}

