/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoHIWorkflow;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowItem;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;

public class ISLookupClient {
    private static final Log log = LogFactory.getLog(ISLookupClient.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public List<String> listSimpleWorflowSections() {
        String xquery = "distinct-values(//WORKFLOW_NAME/@menuSection/string())";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("distinct-values(//WORKFLOW_NAME/@menuSection/string())");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error obtaining worflowSections", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<WorkflowItem> listWorflowsForSection(String name) {
        return this.listWorflowsByCondition("//WORKFLOW_NAME/@menuSection='" + name + "'");
    }

    public List<WorkflowItem> listWorflowsForDatasource(String dsId) {
        return this.listWorflowsByCondition("//DATASOURCE/@id='" + dsId + "'");
    }

    public List<WorkflowItem> listWorflowsForApi(String dsId, String ifaceId) {
        return this.listWorflowsByCondition("//DATASOURCE[@id='" + dsId + "' and @interface='" + ifaceId + "']");
    }

    private List<WorkflowItem> listWorflowsByCondition(String cond) {
        String query = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x" + cond + " order by $x//WORKFLOW_NAME return concat($x//RESOURCE_IDENTIFIER/@value, ' ==@== ', $x//WORKFLOW_NAME, ' ==@== ', $x//WORKFLOW_DESCRIPTION, ' ==@== ', $x//DESTROY_WORKFLOW_TEMPLATE/@id)";
        try {
            return Lists.transform((List)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query), (Function)new Function<String, WorkflowItem>(){

                public WorkflowItem apply(String s) {
                    String[] arr = s.split("==@==");
                    return new WorkflowItem(arr[0].trim(), arr[1].trim(), arr[2].trim(), arr[3].trim().length() > 0);
                }
            });
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error obtaining wfs using query: " + query), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public String getProfile(String id) {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(id);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error finding profile: " + id), (Throwable)e);
            return null;
        }
    }

    public String getRepoProfile(String id) throws ISLookUpException {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(id);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')/*[.//DATASOURCE_ORIGINAL_ID='" + id + "']");
        }
    }

    public Set<String> getNotConfiguredNodes(String id) {
        String query = "for $x in (/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//NODE) where count($x//PARAM[@required='true' and string-length(normalize-space(.)) = 0]) > 0 return $x/@name/string()";
        try {
            List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query);
            return Sets.newHashSet((Iterable)list);
        }
        catch (Exception e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return Sets.newHashSet();
        }
    }

    public List<RepoHIWorkflow> listRepoHiWorkflows(String compliance, String type) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)compliance) && StringUtils.isNotBlank((CharSequence)type)) {
            try {
                String query = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/ui/workflows/xquery/find_repohi.xquery"));
                SAXReader reader = new SAXReader();
                for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query)) {
                    Document doc = reader.read((Reader)new StringReader(s));
                    HashSet ifcTypes = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)doc.valueOf("//TYPES")));
                    HashSet compliances = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)doc.valueOf("//COMPLIANCES")));
                    if (!this.isValidRepoHiTerm(compliance, compliances) || !this.isValidRepoHiTerm(type, ifcTypes)) continue;
                    String id = doc.valueOf("//ID");
                    String name = doc.valueOf("//NAME");
                    String desc = doc.valueOf("//DESC");
                    ArrayList<Pair<String, String>> fields = new ArrayList<Pair<String, String>>();
                    for (Object o : doc.selectNodes(".//FIELD")) {
                        Node currentNode = (Node)o;
                        String key = currentNode.valueOf("@name");
                        String value = currentNode.getText();
                        fields.add((Pair<String, String>)new Pair((Object)key, (Object)value));
                    }
                    RepoHIWorkflow r = new RepoHIWorkflow(id, name, desc, ifcTypes, compliances, fields);
                    list.add(r);
                }
                Collections.sort(list);
            }
            catch (Exception e) {
                log.error((Object)"Error finding repo-hi wfs", (Throwable)e);
            }
        }
        return list;
    }

    private boolean isValidRepoHiTerm(String term, Set<String> valids) {
        if (StringUtils.isBlank((CharSequence)term)) {
            return false;
        }
        if (valids.size() == 0) {
            return true;
        }
        boolean res = false;
        for (String v : valids) {
            if (!term.startsWith(v)) continue;
            res = true;
        }
        return res;
    }

    public List<String> listWfFamilies() {
        String query = "distinct-values(for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where string-length($x//DATASOURCE/@id) > 0 return $x//WORKFLOW_TYPE/@text())";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("distinct-values(for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where string-length($x//DATASOURCE/@id) > 0 return $x//WORKFLOW_TYPE/@text())");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error executing xquery: distinct-values(for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where string-length($x//DATASOURCE/@id) > 0 return $x//WORKFLOW_TYPE/@text())", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public String getDatasourceName(String dsId) {
        String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//OFFICIAL_NAME/text()";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public List<Map<String, String>> obtainSubWorkflows(String wfId) {
        try {
            ClassPathResource resource = new ClassPathResource("/eu/dnetlib/functionality/modular/xquery/listSubWorkflows.xquery.st");
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)resource.getInputStream()));
            st.setAttribute("wfId", (Object)wfId);
            List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(st.toString());
            SAXReader reader = new SAXReader();
            return list.stream().map(s -> {
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Object o : reader.read((Reader)new StringReader((String)s)).selectNodes("/res/*")) {
                        map.put(((Node)o).getName(), ((Node)o).getText());
                    }
                    return map;
                }
                catch (DocumentException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (Throwable e) {
            log.error((Object)("Error obtaining subWorkflows of " + wfId), e);
            return new ArrayList<Map<String, String>>();
        }
    }
}

