function common_init($scope, $http) {
	initSpinner();
	showSpinner();
	$scope.show = '';

	//load export metadata formats
	$http.get('getExportMDFs.do')
		.success(
			function (data) {
				$scope.exportFormats = data;
			}
		)
		.error(
			function () {
				show_notification('error', 'Cannot load info about export metadata formats ');
			}
		);

	//load source metadata formats (MetadataReference instances)
	$http.get('getSourceMDFs.do')
		.success(
			function (data) {
				$scope.srcFormats = data;
			}
		)
		.error(
			function () {
				show_notification('error', 'Cannot load info about source metadata formats ');
			}
		);

	//load OAI set names
	$http.get('getSetSpecs.do')
		.success(
			function (data) {
				$scope.setSpecs = data;
			}
		)
		.error(
			function () {
				show_notification('error', 'Cannot load info about OAI sets ');
			}
		);
	hideSpinner();
}

function removeFromList(list, object) {
	var index = list.indexOf(object);
	list.splice(index, 1);
}

function contains(list, object) {
	return !!~list.indexOf(object);
}

function upsertExportFormat(list, format, formatPrefix) {
	for (var i = 0; i < list.length; i++) {
		if (list[i].prefix == formatPrefix) {
			list[i] = format;
			return i;
		}
	}
	//if I haven't found it, then let's add it
	list[i] = format;
	return -1;
}
