/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.vocabularies.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Relation;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Synonym;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Term;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Vocabulary;
import eu.dnetlib.functionality.modular.ui.vocabularies.persistence.VocabularyDAO;
import eu.dnetlib.functionality.modular.ui.vocabularies.persistence.VocabularyException;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RegistryServiceVocabularyDAO
extends VocabularyDAO {
    @Override
    public List<Vocabulary> getVocabularies() throws VocabularyException {
        try {
            String query = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') order by $x//VOCABULARY_NAME return concat ($x//RESOURCE_IDENTIFIER/@value,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_NAME,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_DESCRIPTION,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_NAME/@code)";
            List vocabularies = Lists.transform((List)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') order by $x//VOCABULARY_NAME return concat ($x//RESOURCE_IDENTIFIER/@value,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_NAME,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_DESCRIPTION,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_NAME/@code)"), s -> {
                String[] tokens = s.split("\u00a7\u00a7\u00a7");
                return new Vocabulary(tokens[0].trim(), tokens[1].trim(), tokens[2].trim(), tokens[3].trim());
            });
            return vocabularies;
        }
        catch (ISLookUpException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
    }

    @Override
    public List<Term> getTerms(String vocabularyId) throws VocabularyException {
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(vocabularyId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            HashMap terms = Maps.newHashMap();
            for (Object t : doc.selectNodes("//TERM")) {
                Term term;
                Element termNode = (Element)t;
                String code = termNode.valueOf("@code");
                if (!terms.containsKey(code)) {
                    term = new Term();
                    term.setEnglishName(termNode.valueOf("@english_name"));
                    term.setNativeName(termNode.valueOf("@native_name"));
                    term.setEncoding(termNode.valueOf("@encoding"));
                    term.setCode(code);
                    term.setSynonyms(new ArrayList<Synonym>());
                    term.setRelations(new ArrayList<Relation>());
                    terms.put(code, term);
                }
                term = (Term)terms.get(code);
                for (Object s : termNode.selectNodes(".//SYNONYM")) {
                    Element synNode = (Element)s;
                    Synonym syn = new Synonym();
                    syn.setTerm(synNode.valueOf("@term"));
                    syn.setEncoding(synNode.valueOf("@encoding"));
                    term.getSynonyms().add(syn);
                }
                for (Object r : termNode.selectNodes(".//RELATION")) {
                    Element relNode = (Element)r;
                    Relation rel = new Relation();
                    rel.setCode(relNode.valueOf("@code"));
                    rel.setType(relNode.valueOf("@type"));
                    term.getRelations().add(rel);
                }
                Collections.sort(term.getSynonyms());
                Collections.sort(term.getRelations());
            }
            ArrayList list = Lists.newArrayList(terms.values());
            Collections.sort(list);
            return list;
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
        catch (ISLookUpException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
        catch (DocumentException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
    }

    @Override
    public void commitTerms(List<Term> terms, String vocabularyId) throws VocabularyException {
        try {
            for (Term t : terms) {
                t.setCode(StringEscapeUtils.escapeXml11((String)t.getCode()));
                t.setEncoding(StringEscapeUtils.escapeXml11((String)t.getEncoding()));
                t.setEnglishName(StringEscapeUtils.escapeXml11((String)t.getEnglishName()));
                t.setNativeName(StringEscapeUtils.escapeXml11((String)t.getNativeName()));
                for (Synonym s : t.getSynonyms()) {
                    s.setEncoding(StringEscapeUtils.escapeXml11((String)s.getEncoding()));
                    s.setTerm(StringEscapeUtils.escapeXml11((String)s.getTerm()));
                }
                for (Relation r : t.getRelations()) {
                    r.setType(StringEscapeUtils.escapeXml11((String)r.getType()));
                    r.setCode(StringEscapeUtils.escapeXml11((String)r.getCode()));
                }
            }
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/templates/terms.xml.st")));
            st.setAttribute("terms", terms);
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(vocabularyId, "//TERMS", st.toString());
        }
        catch (IOException e) {
            throw new VocabularyException(e);
        }
        catch (ISRegistryException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
    }

    @Override
    public void commitVocabularyInfo(Vocabulary voc, String vocabularyId) throws VocabularyException {
        try {
            String xml = "<VOCABULARY_DESCRIPTION>{desc}</VOCABULARY_DESCRIPTION>";
            xml = xml.replace("{desc}", StringEscapeUtils.escapeXml11((String)voc.getDescription()));
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(vocabularyId, "//VOCABULARY_DESCRIPTION", xml);
        }
        catch (ISRegistryException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
    }

    @Override
    public String createVocabulary(Vocabulary voc) throws VocabularyException {
        try {
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/templates/vocabulary.xml.st")));
            st.setAttribute("name", (Object)voc.getName());
            st.setAttribute("description", (Object)voc.getDescription());
            st.setAttribute("code", (Object)voc.getCode());
            st.setAttribute("date", (Object)DateUtils.now_ISO8601());
            String newVocabularyId = ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(st.toString());
            return newVocabularyId;
        }
        catch (IOException e) {
            throw new VocabularyException(e);
        }
        catch (ISRegistryException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
    }

    @Override
    public void dropVocabulary(String vocabularyId) throws VocabularyException {
        try {
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).deleteProfile(vocabularyId);
        }
        catch (ISRegistryDocumentNotFoundException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
        catch (ISRegistryException e) {
            throw new VocabularyException((Exception)((Object)e));
        }
    }
}

