/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DnetParamValuesController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(DnetParamValuesController.class);
    @Autowired
    private List<ValidNodeValuesFetcher> validNodesFetchers;

    @RequestMapping(value={"/ui/wf/obtainValidValues.do"})
    @ResponseBody
    public List<ValidNodeValuesFetcher.DnetParamValue> obtainValidValues(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="bean", required=true) String bean) throws IOException {
        ValidNodeValuesFetcher fetcher = this.findValidNodeValuesFetcher(bean);
        if (fetcher == null) {
            log.error((Object)("ValidNodeValuesFetcher not found: " + bean));
            return new ArrayList<ValidNodeValuesFetcher.DnetParamValue>();
        }
        Map<String, String> params = this.findParams(request);
        List list = fetcher.apply(params);
        Collections.sort(list);
        if (params.containsKey("filter")) {
            String filter = params.get("filter");
            return list.stream().filter(it -> it.getName().contains(filter)).collect(Collectors.toList());
        }
        return list;
    }

    private ValidNodeValuesFetcher findValidNodeValuesFetcher(String bean) {
        for (ValidNodeValuesFetcher fetcher : this.validNodesFetchers) {
            if (!fetcher.getName().equals(bean)) continue;
            return fetcher;
        }
        return null;
    }

    private Map<String, String> findParams(HttpServletRequest request) {
        HashMap params = Maps.newHashMap();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            params.put(name, request.getParameter(name));
        }
        return params;
    }
}

