package eu.dnetlib.functionality.modular.ui.workflows.objects;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;

import eu.dnetlib.msro.workflows.procs.WorkflowProcess;

public class WorkflowUpdateInfo implements Comparable<WorkflowUpdateInfo> {

	private String wfId;
	private WorkflowProcess.StartMode mode;
	private int priority;
	private List<WorkflowNotificationInfo> notifications = new ArrayList<>();
	private boolean scheduled;
	private String cron;
	private int interval;

	public WorkflowUpdateInfo() {}

	public WorkflowUpdateInfo(final String wfId,
			final WorkflowProcess.StartMode mode,
			final int priority,
			final List<WorkflowNotificationInfo> notifications,
			final boolean scheduled,
			final String cron,
			final int interval) {
		this.wfId = wfId;
		this.mode = mode;
		this.priority = priority;
		this.setNotifications(notifications);
		this.scheduled = scheduled;
		this.cron = cron;
		this.interval = interval;
	}

	public String getWfId() {
		return this.wfId;
	}

	public void setWfId(final String wfId) {
		this.wfId = wfId;
	}

	public WorkflowProcess.StartMode getMode() {
		return this.mode;
	}

	public void setMode(final WorkflowProcess.StartMode mode) {
		this.mode = mode;
	}

	public int getPriority() {
		return this.priority;
	}

	public void setPriority(final int priority) {
		this.priority = priority;
	}

	public List<WorkflowNotificationInfo> getNotifications() {
		return this.notifications;
	}

	public void setNotifications(final List<WorkflowNotificationInfo> notifications) {
		this.notifications = notifications;
	}

	public boolean isScheduled() {
		return this.scheduled;
	}

	public void setScheduled(final boolean scheduled) {
		this.scheduled = scheduled;
	}

	public String getCron() {
		return this.cron;
	}

	public void setCron(final String cron) {
		this.cron = cron;
	}

	public int getInterval() {
		return this.interval;
	}

	public void setInterval(final int interval) {
		this.interval = interval;
	}

	public String toJson() {
		return (new Gson()).toJson(this);
	}

	@Override
	public int compareTo(final WorkflowUpdateInfo o) {
		return getWfId().compareTo(o.getWfId());
	}

}
