package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.ProtocolParameterValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ListProtocolFieldValues extends ValidNodeValuesFetcher {

	private static final Log log = LogFactory.getLog(ListProtocolFieldValues.class);
	private final ExecutorService pool = Executors.newFixedThreadPool(10);
	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {
		verifyParams(params, "baseUrl", "protocol", "field");

		final String protocol = params.get("protocol");
		final String baseUrl = params.get("baseUrl");
		final String field = params.get("field");

		final Future<List<DnetParamValue>> futureList = this.pool.submit(new Callable<List<DnetParamValue>>() {

			@Override
			public List<DnetParamValue> call() throws Exception {
				final List<ProtocolParameterValue> list =
						getServiceLocator().getService(CollectorService.class).listValidValuesForParam(protocol, baseUrl, field, null);

				return Lists.newArrayList(Lists.transform(list, new Function<ProtocolParameterValue, ValidNodeValuesFetcher.DnetParamValue>() {

					@Override
					public DnetParamValue apply(final ProtocolParameterValue ppv) {
						return new DnetParamValue(ppv.getId(), ppv.getName());
					}
				}));
			}
		});

		try {
			return futureList.get(10, TimeUnit.SECONDS);
		} catch (final Exception e) {
			log.error("Error obtaining values of protocol: " + protocol);
			futureList.cancel(true);
			return new ArrayList<DnetParamValue>();
		}
	}

	public UniqueServiceLocator getServiceLocator() {
		return this.serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

}
