var lightUiControllers = angular.module('lightUiControllers', []);

function common_init($scope, $http, $sce, $location) {
	initSpinner();
	$scope.showError = function (error) {
		show_notification("error", error);
	}
	$scope.showNotification = function (message) {
		show_notification("info", message);
	}
	$scope.showSpinner = function () {
		showSpinner();
	}
	$scope.hideSpinner = function () {
		hideSpinner();
	}
	$scope.to_trusted = function (html) {
		return $sce.trustAsHtml(html);
	}
	$scope.go = function (path) {
		$location.path(path);
	}
	$scope.encodeValue = function (val) {
		return val;
	}
}


lightUiControllers.controller('lightUiFormCtrl', [
	'$scope', '$http', '$sce', '$location',
	function ($scope, $http, $sce, $location) {
		common_init($scope, $http, $sce, $location);

		$scope.formFields = getFormFields();
		$scope.queryOperators = getOperators();
		$scope.queryParams = {};

		$scope.search = function () {
			var query = "";

			angular.forEach($scope.queryParams, function (value, key) {
				if (query) {
					query += ' AND ';
				}
				if (value) {
					query += '(' + key + ' ' + $scope.queryOperators[key] + ' "' + $scope.encodeValue(value) + '")';
				}
			});

			if (!query) {
				query = "(*=*)";
			}

			$scope.go('/results/1/' + encodeURIComponent(query));
		}
	}
]);

lightUiControllers.controller('lightUiResultsCtrl', [
	'$scope', '$http', '$sce', '$routeParams', '$location', '$timeout', 'sharedProperties',
	function ($scope, $http, $sce, $routeParams, $location, $timeout, sharedProperties) {
		common_init($scope, $http, $sce, $location);

		$scope.page = $routeParams.page;
		$scope.query = $routeParams.query;

		$scope.browseResultsHtml = "";
		$scope.browseOneLabel = "";
		$scope.browseOneHtml = "";
		$scope.searchResults = {};

		$scope.browse = function () {
			$scope.browseResultsHtml = "";

			$scope.showSpinner();

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('lightui_browse', $.param({
				'ui': getLightUiId(),
				'query': $scope.query,
			})).success(function (data) {
				$scope.hideSpinner();
				$scope.browseResultsHtml = data;
				sharedProperties.setBrowseHtml(data);
			}).error(function () {
				$scope.showError('Something really bad must have happened to our fellow hamster..');
				$scope.hideSpinner();
			});
		}

		$scope.browse_one = function (field, label) {
			$scope.browseOneHtml = "";
			$scope.browseOneLabel = label;

			$scope.showSpinner();

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('lightui_browse_one', $.param({
				'ui': getLightUiId(),
				'query': $scope.query,
				'field': field,
				'label': label
			})).success(function (data) {
				$scope.hideSpinner();
				$scope.browseOneHtml = data;
			}).error(function () {
				$scope.showError('Something really bad must have happened to our fellow hamster..');
				$scope.hideSpinner();
			});
		}

		$scope.search = function () {
			if ($scope.query != sharedProperties.getQuery()) {
				$scope.searchResults = {};
			} else {
				$scope.searchResults = {
					'currPage': $scope.page,
					'totalPages': sharedProperties.getTotalPages(),
					'total': sharedProperties.getTotal(),
					'html': ''
				}
			}

			$scope.showSpinner();

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('lightui_search', $.param({
				'ui': getLightUiId(),
				'query': $scope.query,
				'page': $scope.page
			})).success(function (data) {
				$scope.hideSpinner();
				$scope.searchResults = data;
				sharedProperties.setTotalPages(data.totalPages);
				sharedProperties.setTotal(data.total);
			}).error(function () {
				$scope.showError('Something really bad must have happened to our fellow hamster..');
				$scope.hideSpinner();
			});
		}

		$scope.pageList = function (results) {
			var res = [];

			var from = Math.max(1, parseInt(results.currPage) - 4);
			var to = Math.min(parseInt(results.totalPages), parseInt(results.currPage) + 4);

			for (var i = from; i <= to; i++) {
				res.push(i);
			}

			return res;
		}

		$scope.updateQueryWithValue = function (field, value, delay) {
			var q = $scope.query;
			if (q) {
				q += " AND ";
			}
			q += '(' + field + ' exact "' + $scope.encodeValue(value) + '")';

			$scope.showSpinner();
			$timeout(function () {
				$scope.hideSpinner();
				$scope.go('/results/1/' + encodeURIComponent(q))
			}, delay);
		}

		$scope.gotoPage = function (p) {
			$scope.go('/results/' + p + '/' + encodeURIComponent($scope.query));
		}

		$scope.getDocument = function (field, id) {
			$scope.go('/doc/' + encodeURIComponent(field) + '/' + encodeURIComponent(id));
		}

		$scope.search();

		if ($scope.query != sharedProperties.getQuery()) {
			$scope.browse();
			sharedProperties.setQuery($scope.query);
		} else {
			$scope.browseResultsHtml = sharedProperties.getBrowseHtml();
			$scope.total = sharedProperties.getTotal();
		}
	}
]);

lightUiControllers.controller('lightUiDocCtrl', [
	'$scope', '$http', '$sce', '$routeParams', '$location',
	function ($scope, $http, $sce, $routeParams, $location) {
		common_init($scope, $http, $sce, $location);

		$scope.documentHTML = '';

		$scope.showSpinner();

		$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
		$http.post('lightui_findone', $.param({
			'ui': getLightUiId(),
			'field': $routeParams.field,
			'id': $routeParams.id
		})).success(function (data) {
			$scope.hideSpinner();
			$scope.documentHTML = data;
		}).error(function () {
			$scope.showError('Something really bad must have happened to our fellow hamster..');
			$scope.hideSpinner();
		});
	}
]);

