var wfGraphViewer = angular.module("wfGraphViewer", []);

wfGraphViewer.directive("wfGraphModal", function ($http) {
	return {
		restrict: 'E',
		replace:true,
		scope: {
	        'wfId'    : '=',
	        'visible' : '='
		},
		templateUrl: '../resources/html/wf/wf-graph-modal.html',
		link: function (scope, element, attrs, ctrl) {
			scope.width = 600;
			scope.height = 400;
			
			scope.graph = {	nodes: [], arcs: [] };
			scope.currentNode = {}
						
			$(element).modal({'show': false});
		
			scope.$watch(function() {
				return scope.visible;
			}, function(value) {
				if (value == true && scope.wfId) { 
					scope.graph = {	nodes: [], arcs: [] };

					$(element).modal('show');
					scope.visible = false;

					showSpinner();
					$http.get('wf/getGraph.do?wfId=' + scope.wfId).success(function (data) {
						scope.rearrangeNodes(data);
						scope.graph = data;
						scope.currentNode = {};
						hideSpinner();
					}).error(function (e) {
						show_notification('error', 'Error fetching graph: ' + e);
						hideSpinner();
					});
				}
			});
			
			scope.showNodeInfo = function(node) {
				scope.currentNode = node;
			};
			
			scope.hideNodeInfo = function() {
				scope.currentNode = {};
			};
						
			scope.rearrangeNodes = function(graph) {
				var nodeLevelSizes = [];
				scope.width = 600;
				scope.height = 400;
				
				angular.forEach(graph.nodes, function (node) {
					node.x = 0;
					node.y = 0;
				});
				angular.forEach(graph.nodes, function (node) {
					if (node.type == 'start') {
						scope.updatePosition(node, 0, graph, nodeLevelSizes);
					}
				});
				angular.forEach(graph.nodes, function (node) {
					scope.width = Math.max(scope.width, node.x + 250);
					scope.height = Math.max(scope.height, node.y + 60);
				});
			};

			scope.updatePosition = function(node, level, graph, nodeLevelSizes) {
				
				if (node.x == 0 && node.y == 0) {
					while (nodeLevelSizes.length <= level) {
						nodeLevelSizes.push(0);
					}

					node.x = (nodeLevelSizes[level] * 230) + 10;
					node.y = (level * 110) + 10;

					nodeLevelSizes[level]++;

					angular.forEach(graph.arcs, function (arc) {
							if (arc.from == node.name) {

								if (arc.from == arc.to) {
									arc.x1 = arc.x2 = node.x + 190;
									arc.y1 = arc.y2 = node.y + 25
								} else {
									angular.forEach(graph.nodes, function (other) {
										if (arc.to == other.name) {
											scope.updatePosition(other, level + 1, graph, nodeLevelSizes);

											var dx = node.x - other.x;
											var dy = node.y - other.y;
											// TODO : linee verticali che si sovrappongono (nodi che distano piu di un livello), linee che passano sotto ai nodi, linee che risalgono,

											if (dy < 0) {
												// linee con frecce in basso

												arc.x1 = node.x + 90;
												arc.y1 = node.y + 55;

												arc.x2 = other.x + 90;
												arc.y2 = other.y - 15;

												var step;
												if (dx > 0) {
													step = Math.min(80, 2 * Math.sqrt(dx));
												} else if (dx < 0) {
													step = Math.max(-80, -2 * Math.sqrt(-dx));
												} else {
													step = 0;
												}
												arc.x1 -= step;
												arc.x2 += step;
											} else if (dy > 0) {
												arc.x1 = node.x + 90;
												arc.y1 = node.y - 15;

												arc.x2 = other.x + 90;
												arc.y2 = other.y + 55;

												var step;
												if (dx > 0) {
													step = Math.min(80, 2 * Math.sqrt(dx));
												} else if (dx < 0) {
													step = Math.max(-80, -2 * Math.sqrt(-dx));
												} else {
													step = 0;
												}
												arc.x1 -= step;
												arc.x2 += step;

											} else {
												// linee orizzonatali
												arc.x1 = node.x;
												arc.x2 = other.x;

												arc.y1 = arc.y2 = node.y + 25 - (Math.min(20, Math.abs(dx / 230) - 1)) * 5;

												if (dx > 0) {
													arc.x1 -= 5;
													arc.x2 += 190;
												} else {
													arc.x1 += 190;
													arc.x2 -= 5;
												}
											}
										}
									});
								}
							}
						}
					);
				}
			};
		}
	}
});


wfGraphViewer.directive('wfGraphNode', function () {
	return {
		restrict: 'E',
		replace: true,
		templateNamespace: 'svg',
		templateUrl: '../resources/html/wf/wf-graph-node.html',
		scope: {
			name:      '@',
			type:      '@',
			classType: '@',
			x:         '@',
			y:         '@',
			funct:     '&'
		}
	}
});

wfGraphViewer.directive('wfGraphArc', function () {
	return {
		restrict: 'E',
		replace: true,
		templateNamespace: 'svg',
		templateUrl: '../resources/html/wf/wf-graph-arc.html',
		scope: {
			name: '@',
			from: '@',
			to:   '@',
			x1:   '@',
			y1:   '@',
			x2:   '@',
			y2:   '@'
		}
	}
});
